/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;

public class RSRecyclerViewWithEmpty
extends RecyclerView {
    public final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    @Nullable
    private View m_emptyView;
    private final RecyclerView.AdapterDataObserver m_dataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            RSRecyclerViewWithEmpty.this.displayEmptyViewIfEmpty();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            RSRecyclerViewWithEmpty.this.displayEmptyViewIfEmpty();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RSRecyclerViewWithEmpty.this.displayEmptyViewIfEmpty();
        }
    };

    public RSRecyclerViewWithEmpty(Context context) {
        super(context);
    }

    public RSRecyclerViewWithEmpty(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RSRecyclerViewWithEmpty(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private void displayEmptyViewIfEmpty() {
        if (null != this.m_emptyView && null != this.getAdapter()) {
            if (0 < this.getAdapter().getItemCount()) {
                this.m_emptyView.setVisibility(8);
            } else {
                this.m_emptyView.setVisibility(0);
            }
        }
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        RecyclerView.Adapter oldAdapter = this.getAdapter();
        if (null != oldAdapter) {
            oldAdapter.unregisterAdapterDataObserver(this.m_dataObserver);
        }
        super.setAdapter(adapter);
        if (null != adapter) {
            adapter.registerAdapterDataObserver(this.m_dataObserver);
        }
        this.displayEmptyViewIfEmpty();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (null != this.m_emptyView && (8 == visibility || 4 == visibility)) {
            this.m_emptyView.setVisibility(8);
        } else {
            this.displayEmptyViewIfEmpty();
        }
    }

    public void setEmptyView(@Nullable View emptyView) {
        this.m_emptyView = emptyView;
        this.displayEmptyViewIfEmpty();
    }
}

