/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.utils;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.view.View;
import com.risesoftware.ui.utils.SystemUiHiderBase;

@TargetApi(value=16)
public class SystemUiHiderJellyBean
extends SystemUiHiderBase {
    public final String TAG = this.getClass().getSimpleName();
    private View.OnSystemUiVisibilityChangeListener mSystemUiVisibilityChangeListener = new View.OnSystemUiVisibilityChangeListener(){

        public void onSystemUiVisibilityChange(int visibility) {
            if ((visibility & SystemUiHiderJellyBean.this.m_testForHiddenFlags) != 0) {
                if (Build.VERSION.SDK_INT < 16) {
                    ActionBar actionBar = SystemUiHiderJellyBean.this.m_activity.getActionBar();
                    if (actionBar != null) {
                        actionBar.hide();
                    }
                    SystemUiHiderJellyBean.this.m_activity.getWindow().setFlags(1024, 1024);
                }
                SystemUiHiderJellyBean.this.m_onVisibilityChangeListener.onVisibilityChange(false);
                SystemUiHiderJellyBean.this.m_visible = false;
            } else {
                SystemUiHiderJellyBean.this.m_anchorView.setSystemUiVisibility(SystemUiHiderJellyBean.this.m_showFlags);
                if (Build.VERSION.SDK_INT < 16) {
                    ActionBar actionBar = SystemUiHiderJellyBean.this.m_activity.getActionBar();
                    if (actionBar != null) {
                        actionBar.show();
                    }
                    SystemUiHiderJellyBean.this.m_activity.getWindow().setFlags(0, 1024);
                }
                SystemUiHiderJellyBean.this.m_onVisibilityChangeListener.onVisibilityChange(true);
                SystemUiHiderJellyBean.this.m_visible = true;
            }
        }
    };

    protected SystemUiHiderJellyBean(Activity activity, View anchorView) {
        super(activity, anchorView);
        Log.e((String)this.TAG, (String)"+++++++++++++ Using SystemUiHiderIceCreamSandwich");
        this.enableFullScreenLayout();
        this.m_anchorView.setOnSystemUiVisibilityChangeListener(this.mSystemUiVisibilityChangeListener);
    }

    @Override
    public final void enableFullScreenLayout() {
        this.m_showFlags = 1792;
        this.m_hideFlags = 1798;
        this.m_testForHiddenFlags = 6;
        this.m_fullscreenLayout = true;
    }

    @Override
    public final void disableFullScreenLayout() {
        this.m_showFlags = 0;
        this.m_hideFlags = 6;
        this.m_testForHiddenFlags = 6;
        this.m_fullscreenLayout = false;
    }

    @Override
    public void setup() {
        this.m_anchorView.setOnSystemUiVisibilityChangeListener(this.mSystemUiVisibilityChangeListener);
    }

    @Override
    public void hide() {
        this.m_anchorView.setSystemUiVisibility(this.m_hideFlags);
    }

    @Override
    public void show() {
        this.m_anchorView.setSystemUiVisibility(this.m_showFlags);
    }
}

