/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.fragment;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.WebView;
import android.widget.TextView;
import com.risesoftware.ui.R;
import com.risesoftware.utils.PackageUtils;

@TargetApi(value=11)
public class RSHTMLAlertDialogFragment
extends DialogFragment {
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private static final String WHATS_NEW_VERSION = "com.risesoftware.RS_HTMLAlertDialogFragment.whatsNewVersion";
    public static final String TITLE = "com.risesoftware.RS_HTMLAlertDialogFragment.title";
    public static final String HTML_FILENAME = "com.risesoftware.RS_HTMLAlertDialogFragment.content.html";
    public static final String ITEMS = "com.risesoftware.RS_HTMLAlertDialogFragment.items";
    public static final String TYPE = "com.risesoftware.RS_HTMLAlertDialogFragment.type";
    public static final int TYPE_ABOUT = 1;
    public static final int TYPE_GENERIC = 2;
    public static final int TYPE_WHATS_NEW = 3;
    private DialogInterface.OnClickListener m_negativeListener = null;
    private DialogInterface.OnClickListener m_neutralListener = null;
    private DialogInterface.OnClickListener m_positiveListener = null;
    private int m_negativeTextID = 0;
    private int m_neutralTextID = 0;
    private int m_positiveTextID = 0;
    private boolean m_addNegativeButton = false;
    private boolean m_addNeutralButton = false;
    private boolean m_addPositiveButton = false;
    private Drawable m_icon = null;
    private int m_iconID = 0;
    private View m_view = null;
    private int m_boxType = 0;

    public static RSHTMLAlertDialogFragment createGenericBox(@StringRes int titleID, String contentHtml) {
        Bundle args = new Bundle();
        args.putInt(TYPE, 2);
        args.putInt(TITLE, titleID);
        args.putString(HTML_FILENAME, contentHtml);
        RSHTMLAlertDialogFragment fragment = new RSHTMLAlertDialogFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public static RSHTMLAlertDialogFragment createAboutBox(@StringRes int titleID, String contentHtml) {
        Bundle args = new Bundle();
        args.putInt(TYPE, 1);
        args.putInt(TITLE, titleID);
        args.putString(HTML_FILENAME, contentHtml);
        RSHTMLAlertDialogFragment fragment = new RSHTMLAlertDialogFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public static RSHTMLAlertDialogFragment createWhatsNewBox(@StringRes int titleID, String htmlFileName, int versionNb) {
        Bundle args = new Bundle();
        args.putInt(TYPE, 3);
        args.putInt(TITLE, titleID);
        args.putString(HTML_FILENAME, htmlFileName);
        args.putInt(WHATS_NEW_VERSION, versionNb);
        RSHTMLAlertDialogFragment fragment = new RSHTMLAlertDialogFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return this.createDialog(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        if (1 == this.m_boxType) {
            TextView rs_txtvwVersion = (TextView)this.m_view.findViewById(R.id.rs_txtvwVersion);
            rs_txtvwVersion.setText((CharSequence)PackageUtils.getAppVersionName((Context)this.getActivity()));
        }
    }

    public void setNegativeListener(int textID, DialogInterface.OnClickListener listener) {
        this.m_addNegativeButton = true;
        this.m_negativeTextID = textID;
        this.m_negativeListener = listener;
    }

    public void setNeutralListener(int textID, DialogInterface.OnClickListener listener) {
        this.m_addNeutralButton = true;
        this.m_neutralTextID = textID;
        this.m_neutralListener = listener;
    }

    public void setPositiveListener(int textID, DialogInterface.OnClickListener listener) {
        this.m_addPositiveButton = true;
        this.m_positiveTextID = textID;
        this.m_positiveListener = listener;
    }

    public void setIcon(Drawable icon) {
        this.m_icon = icon;
    }

    public void setIconID(int iconID) {
        this.m_iconID = iconID;
    }

    public void setView(View view) {
        this.m_view = view;
    }

    public void showOnVersionChanged(Context context, FragmentManager fragmentManager, String tag) {
        SharedPreferences prefs;
        int versionShown;
        Bundle args = this.getArguments();
        String filename = "";
        int currentVersion = 0;
        if (null != args) {
            if (args.containsKey(HTML_FILENAME)) {
                filename = args.getString(HTML_FILENAME, "");
            }
            if (args.containsKey(WHATS_NEW_VERSION)) {
                currentVersion = args.getInt(WHATS_NEW_VERSION, 0);
            }
        }
        if (currentVersion > (versionShown = (prefs = PreferenceManager.getDefaultSharedPreferences((Context)context)).getInt(filename, -1))) {
            SharedPreferences.Editor edit = prefs.edit();
            edit.putInt(filename, currentVersion);
            edit.commit();
            this.show(fragmentManager, tag);
        }
    }

    private Dialog createDialog(Bundle savedInstanceState) throws Resources.NotFoundException {
        Bundle args;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        if (0 != this.m_iconID) {
            Resources resources = this.getActivity().getResources();
            this.m_icon = resources.getDrawable(this.m_iconID);
        }
        builder.setCancelable(true).setIcon(this.m_icon);
        if (this.m_addNegativeButton) {
            if (0 == this.m_negativeTextID) {
                this.m_negativeTextID = 0x1040000;
            }
            builder.setNegativeButton(this.m_negativeTextID, this.m_negativeListener);
        }
        if (this.m_addNeutralButton) {
            if (0 == this.m_neutralTextID) {
                this.m_neutralTextID = 17039369;
            }
            builder.setNeutralButton(this.m_neutralTextID, this.m_neutralListener);
        }
        if (this.m_addPositiveButton) {
            if (0 == this.m_positiveTextID) {
                this.m_positiveTextID = 17039370;
            }
            builder.setPositiveButton(this.m_positiveTextID, this.m_positiveListener);
        }
        if (null != (args = this.getArguments())) {
            if (args.containsKey(TYPE)) {
                this.m_boxType = args.getInt(TYPE);
            }
            if (args.containsKey(ITEMS)) {
                int iemsID = args.getInt(ITEMS);
                CharSequence[] items = this.getResources().getTextArray(iemsID);
                builder.setItems(items, this.m_negativeListener);
            }
            if (args.containsKey(TITLE)) {
                int title = args.getInt(TITLE);
                builder.setTitle(title);
            }
            if (!args.containsKey(HTML_FILENAME)) {
                throw new RuntimeException("Oops");
            }
            String title = args.getString(HTML_FILENAME);
            String htmlResource = "file:///android_asset/" + title;
            LayoutInflater layoutInflater = this.getActivity().getLayoutInflater();
            switch (this.m_boxType) {
                case 2: {
                    this.m_view = layoutInflater.inflate(R.layout.rs_generic, null);
                    WebView rs_wbvwWebView = (WebView)this.m_view.findViewById(R.id.rs_wbvwWebView);
                    rs_wbvwWebView.loadUrl(htmlResource);
                    break;
                }
                case 1: {
                    this.m_view = layoutInflater.inflate(R.layout.rs_about, null);
                    WebView rs_wbvwWebView = (WebView)this.m_view.findViewById(R.id.rs_wbvwWebView);
                    rs_wbvwWebView.loadUrl(htmlResource);
                    break;
                }
                case 3: {
                    this.m_view = layoutInflater.inflate(R.layout.rs_generic, null);
                    WebView rs_wbvwWebView = (WebView)this.m_view.findViewById(R.id.rs_wbvwWebView);
                    rs_wbvwWebView.loadUrl(htmlResource);
                }
            }
        }
        if (null == this.m_view) {
            throw new RuntimeException("Oops");
        }
        builder.setView(this.m_view);
        return builder.create();
    }
}

