/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.TextView;
import com.risesoftware.ui.R;
import java.util.EnumSet;

public class RSDialogFragmentYesNoCancel
extends DialogFragment {
    public final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected int m_layoutId = R.layout.rs_dialog_yes_no_cancel;
    protected int m_yesIconId = R.drawable.rs_ic_yes;
    protected int m_noIconId = R.drawable.rs_ic_no;
    protected int m_cancelIconId = R.drawable.rs_ic_cancel;
    protected int m_paddingBetweenButtons = R.dimen.rs_paddingBetweenButtons;
    protected int m_textStyleId = 16973886;
    protected int m_titleId = 0;
    protected int m_textId = 0;
    protected CharSequence m_title;
    protected CharSequence m_text;
    protected Listener m_listener = null;
    protected EnumSet<Buttons> m_buttons = EnumSet.allOf(Buttons.class);

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.init((Context)activity, attrs);
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.YesNoCancelDialogFragment, 0, 0);
        try {
            int resourceId;
            if (-1 == this.m_yesIconId) {
                this.m_yesIconId = typedArray.getResourceId(R.styleable.YesNoCancelDialogFragment_yesIconResource, R.drawable.rs_ic_yes);
            }
            if (-1 == this.m_noIconId) {
                this.m_noIconId = typedArray.getResourceId(R.styleable.YesNoCancelDialogFragment_noIconResource, R.drawable.rs_ic_no);
            }
            if (-1 == this.m_cancelIconId) {
                this.m_cancelIconId = typedArray.getResourceId(R.styleable.YesNoCancelDialogFragment_cancelIconResource, R.drawable.rs_ic_cancel);
            }
            if (-1 == this.m_paddingBetweenButtons) {
                this.m_paddingBetweenButtons = typedArray.getDimensionPixelOffset(R.styleable.YesNoCancelDialogFragment_paddingBetweenButtons, 10);
            }
            if (-1 == this.m_textStyleId) {
                this.m_textStyleId = typedArray.getResourceId(R.styleable.YesNoCancelDialogFragment_textStyle, 16973886);
            }
            if (null != this.m_text && -1 != (resourceId = typedArray.getResourceId(R.styleable.YesNoCancelDialogFragment_textResource, -1))) {
                this.m_text = this.getString(resourceId);
            }
            if (null != this.m_title && -1 != (resourceId = typedArray.getResourceId(R.styleable.YesNoCancelDialogFragment_titleResource, -1))) {
                this.m_title = this.getString(resourceId);
            }
            if (typedArray.getBoolean(R.styleable.YesNoCancelDialogFragment_hideYes, false)) {
                this.hideYes();
            }
            if (typedArray.getBoolean(R.styleable.YesNoCancelDialogFragment_hideNo, false)) {
                this.hideNo();
            }
            if (typedArray.getBoolean(R.styleable.YesNoCancelDialogFragment_hideCancel, false)) {
                this.hideCancel();
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    public void setLayoutId(@LayoutRes int layoutId) {
        this.m_layoutId = layoutId;
    }

    public void setTitle(CharSequence title) {
        this.m_title = title;
    }

    public void setTitle(@StringRes int titleResourceId) {
        this.m_titleId = titleResourceId;
    }

    public void setText(CharSequence text) {
        this.m_text = text;
    }

    public void setText(@StringRes int textResourceId) {
        this.m_textId = textResourceId;
    }

    public void setTextStyleId(@StyleRes int textStyleId) {
        this.m_textStyleId = textStyleId;
    }

    public void setYesIconId(@DrawableRes int yesIconId) {
        this.m_yesIconId = yesIconId;
    }

    public void setNoIconId(@DrawableRes int noIconId) {
        this.m_noIconId = noIconId;
    }

    public void setCancelIconId(@DrawableRes int cancelIconId) {
        this.m_cancelIconId = cancelIconId;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ImageButton imgbtn_cancel;
        ImageButton imgbtn_no;
        ImageButton imgbtn_yes;
        TextView txtvwTitle;
        View view = inflater.inflate(this.m_layoutId, container);
        TextView txtvw_message = (TextView)view.findViewById(R.id.txtvwMessage);
        if (null != txtvw_message) {
            if (0 != this.m_textId) {
                this.m_text = this.getString(this.m_textId);
            }
            txtvw_message.setText(this.m_text);
        }
        if (null != (txtvwTitle = (TextView)view.findViewById(R.id.txtvwTitle))) {
            if (0 != this.m_titleId) {
                this.m_title = this.getString(this.m_titleId);
            }
            txtvwTitle.setText(this.m_title);
        }
        if (null != (imgbtn_yes = (ImageButton)view.findViewById(R.id.imgbtnYes))) {
            if (this.m_buttons.contains((Object)Buttons.YES)) {
                imgbtn_yes.setImageResource(this.m_yesIconId);
                imgbtn_yes.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != RSDialogFragmentYesNoCancel.this.m_listener) {
                            RSDialogFragmentYesNoCancel.this.m_listener.onClickYes();
                        }
                        RSDialogFragmentYesNoCancel.this.dismiss();
                    }
                });
            } else {
                imgbtn_yes.setVisibility(8);
            }
        }
        if (null != (imgbtn_no = (ImageButton)view.findViewById(R.id.imgbtnNo))) {
            if (this.m_buttons.contains((Object)Buttons.NO)) {
                imgbtn_no.setImageResource(this.m_noIconId);
                imgbtn_no.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != RSDialogFragmentYesNoCancel.this.m_listener) {
                            RSDialogFragmentYesNoCancel.this.m_listener.onClickNo();
                        }
                        RSDialogFragmentYesNoCancel.this.dismiss();
                    }
                });
            } else {
                imgbtn_no.setVisibility(8);
            }
        }
        if (null != (imgbtn_cancel = (ImageButton)view.findViewById(R.id.imgbtnCancel))) {
            if (this.m_buttons.contains((Object)Buttons.CANCEL)) {
                imgbtn_cancel.setImageResource(this.m_cancelIconId);
                imgbtn_cancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != RSDialogFragmentYesNoCancel.this.m_listener) {
                            RSDialogFragmentYesNoCancel.this.m_listener.onClickCancel();
                        }
                        RSDialogFragmentYesNoCancel.this.dismiss();
                    }
                });
            } else {
                imgbtn_cancel.setVisibility(8);
            }
        }
        return view;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        return dialog;
    }

    public void onStart() {
        super.onStart();
        Window window = this.getDialog().getWindow();
        WindowManager.LayoutParams windowParams = window.getAttributes();
        windowParams.dimAmount = 0.0f;
        window.setAttributes(windowParams);
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (this.m_buttons.contains((Object)Buttons.CANCEL) && null != this.m_listener) {
            this.m_listener.onClickCancel();
        }
    }

    public void hideYes() {
        this.m_buttons.remove((Object)Buttons.YES);
    }

    public void hideNo() {
        this.m_buttons.remove((Object)Buttons.NO);
    }

    public void hideCancel() {
        this.m_buttons.remove((Object)Buttons.CANCEL);
    }

    public static interface Listener {
        public void onClickYes();

        public void onClickNo();

        public void onClickCancel();
    }

    public static enum Buttons {
        YES,
        NO,
        CANCEL;

    }
}

