/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.graphics;

import android.graphics.Bitmap;

public final class ImageSkewerOptions {
    private final Bitmap m_originalBitmap;
    private final float m_scaleX;
    private final float m_scaleY;
    private final float m_rotateX;
    private final float m_rotateY;
    private final float m_rotateZ;
    private final float m_skewX;
    private final float m_skewY;

    private ImageSkewerOptions(Builder builder) {
        this.m_originalBitmap = builder.m_originalBitmap;
        this.m_scaleX = builder.m_scaleX;
        this.m_scaleY = builder.m_scaleY;
        this.m_rotateX = builder.m_rotateX;
        this.m_rotateY = builder.m_rotateY;
        this.m_rotateZ = builder.m_rotateZ;
        this.m_skewX = builder.m_skewX;
        this.m_skewY = builder.m_skewY;
    }

    public Bitmap originalBitmap() {
        return this.m_originalBitmap;
    }

    public float scaleX() {
        return this.m_scaleX;
    }

    public float scaleY() {
        return this.m_scaleY;
    }

    public float rotateX() {
        return this.m_rotateX;
    }

    public float rotateY() {
        return this.m_rotateY;
    }

    public float rotateZ() {
        return this.m_rotateZ;
    }

    public float skewX() {
        return this.m_skewX;
    }

    public float skewY() {
        return this.m_skewY;
    }

    public static ImageSkewerOptions createSimple() {
        return new Builder().build();
    }

    public static class Builder {
        private Bitmap m_originalBitmap = null;
        private float m_scaleX = 1.0f;
        private float m_scaleY = 1.0f;
        private float m_rotateX = 0.0f;
        private float m_rotateY = 0.0f;
        private float m_rotateZ = 0.0f;
        private float m_skewX = 0.0f;
        private float m_skewY = 0.0f;

        public Builder setOriginalBitmap(Bitmap originalBitmap) {
            this.m_originalBitmap = originalBitmap;
            return this;
        }

        public Builder setScale(float scaleX, float scaleY) {
            this.m_scaleX = scaleX;
            this.m_scaleY = scaleY;
            return this;
        }

        public Builder setRotationX(float rotateX) {
            this.m_rotateX = rotateX;
            return this;
        }

        public Builder setRotationY(float rotateY) {
            this.m_rotateY = rotateY;
            return this;
        }

        public Builder setRotationZ(float rotateZ) {
            this.m_rotateZ = rotateZ;
            return this;
        }

        public Builder setRotation(float rotateX, float rotateY, float rotateZ) {
            this.m_rotateX = rotateX;
            this.m_rotateY = rotateY;
            this.m_rotateZ = rotateZ;
            return this;
        }

        public Builder setSkew(float skewX, float skewY) {
            this.m_skewX = skewX;
            this.m_skewY = skewY;
            return this;
        }

        public Builder cloneFrom(ImageSkewerOptions skewOptions) {
            this.m_originalBitmap = skewOptions.m_originalBitmap;
            this.m_scaleX = skewOptions.m_scaleX;
            this.m_scaleY = skewOptions.m_scaleY;
            this.m_rotateX = skewOptions.m_rotateX;
            this.m_rotateY = skewOptions.m_rotateY;
            this.m_rotateZ = skewOptions.m_rotateZ;
            this.m_skewX = skewOptions.m_skewX;
            this.m_skewY = skewOptions.m_skewY;
            return this;
        }

        public ImageSkewerOptions build() {
            return new ImageSkewerOptions(this);
        }
    }
}

