/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.activity;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import com.risesoftware.ui.R;
import com.risesoftware.ui.activity.RSReceiverAdminLockedActivity;
import com.risesoftware.ui.fragment.RSDialogFragmentEnterPin;
import com.risesoftware.ui.utils.SystemUiHiderBase;

public abstract class RSActivityLocked
extends Activity {
    public final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    public static final String PREF_LOCKED_ALWAYS = "PREF_LOCKED_ALWAYS";
    public static final String PREF_LOCKED_DO_NOTIFY = "PREF_LOCKED_DO_NOTIFY";
    public static final String PREF_LOCKED_NOTIFY_RINGTONE = "PREF_LOCKED_NOTIFY_RINGTONE";
    public static final String PREF_LOCKED_NOTIFY_DO_VIBRATE = "PREF_LOCKED_NOTIFY_DO_VIBRATE";
    public static final String PREF_LOCKED_LOCK_SCREEN_ON_EXIT = "PREF_LOCKED_LOCK_SCREEN_ON_EXIT";
    private boolean m_activityIsLocked = false;
    private SystemUiHiderBase m_systemUiHider;

    protected RSActivityLocked() {
    }

    public abstract void onActivityLocked();

    public abstract void onActivityUnlocked();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext());
        this.m_activityIsLocked = sharedPref.getBoolean(PREF_LOCKED_ALWAYS, false);
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        View contentView = this.getWindow().getDecorView().findViewById(0x1020002);
        this.m_systemUiHider = SystemUiHiderBase.getInstance(this, contentView);
        if (this.m_activityIsLocked) {
            this.onActivityLocked();
        } else {
            this.onActivityUnlocked();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.m_activityIsLocked) {
            this.m_systemUiHider.hide();
        }
    }

    public void onBackPressed() {
        if (this.isActivityIsLocked()) {
            RSDialogFragmentEnterPin dialogFragmentEnterPin = new RSDialogFragmentEnterPin();
            dialogFragmentEnterPin.setPinListener(new RSDialogFragmentEnterPin.PinListener(){

                @Override
                public void onPinSucceeded() {
                    RSActivityLocked.super.onBackPressed();
                }

                @Override
                public void onPinFailed() {
                }

                @Override
                public void onCancelled() {
                }
            });
            dialogFragmentEnterPin.show(this.getFragmentManager(), this.TAG);
        } else {
            RSActivityLocked.super.onBackPressed();
        }
    }

    protected void onUserLeaveHint() {
        Log.d((String)this.TAG, (String)"onUserLeaveHint");
        if (this.m_activityIsLocked) {
            this.doEscapedLockedActivity();
        }
    }

    public boolean isActivityIsLocked() {
        return this.m_activityIsLocked;
    }

    protected void lockActivity() {
        this.m_activityIsLocked = true;
        this.m_systemUiHider.hide();
        this.onActivityLocked();
    }

    protected void unlockActivity() {
        this.m_activityIsLocked = false;
        this.m_systemUiHider.show();
        this.onActivityUnlocked();
    }

    protected void toggleSystemUi() {
        if (this.m_systemUiHider.isVisible()) {
            this.hideSystemUi();
        } else {
            this.showSystemUi();
        }
    }

    protected void hideSystemUi() {
        this.m_systemUiHider.hide();
    }

    protected void showSystemUi() {
        this.m_systemUiHider.show();
    }

    protected boolean isFullScreenLayout() {
        return this.m_systemUiHider.isFullScreenLayout();
    }

    protected void toggleFullScreenLayout() {
        this.m_systemUiHider.toggleFullScreenLayout();
    }

    protected void enableFullScreenLayout() {
        this.m_systemUiHider.enableFullScreenLayout();
    }

    protected void disableFullScreenLayout() {
        this.m_systemUiHider.disableFullScreenLayout();
    }

    private void doEscapedLockedActivity() {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext());
        boolean doNotify = sharedPref.getBoolean(PREF_LOCKED_DO_NOTIFY, true);
        if (doNotify) {
            ComponentName componentName;
            DevicePolicyManager devicePolicyManager;
            boolean isAdmin;
            try {
                boolean doVibrate;
                Notification.Builder notificationBuilder = new Notification.Builder((Context)this);
                notificationBuilder.setAutoCancel(true);
                notificationBuilder.setSmallIcon(this.getApplication().getApplicationInfo().icon);
                notificationBuilder.setContentTitle((CharSequence)this.getString(R.string.appNameForNotification));
                notificationBuilder.setContentText((CharSequence)this.getString(R.string.notificationAppClosed));
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)new Intent(), (int)0);
                notificationBuilder.setContentIntent(pendingIntent);
                Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.getApplication().getApplicationInfo().icon);
                notificationBuilder.setLargeIcon(bitmap);
                String prefRingtone = sharedPref.getString(PREF_LOCKED_NOTIFY_RINGTONE, Settings.System.DEFAULT_ALARM_ALERT_URI.toString());
                if (!prefRingtone.isEmpty()) {
                    Uri notificationUri = Uri.parse((String)prefRingtone);
                    notificationBuilder.setSound(notificationUri, 4);
                }
                if (doVibrate = sharedPref.getBoolean(PREF_LOCKED_NOTIFY_DO_VIBRATE, true)) {
                    notificationBuilder.setVibrate(new long[]{0L, 1000L, 1000L, 1000L});
                }
                NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
                notificationManager.notify(1, notificationBuilder.getNotification());
            }
            catch (RuntimeException e) {
                Log.e((String)this.TAG, (String)e.getMessage(), (Throwable)e);
            }
            boolean doLockScreen = sharedPref.getBoolean(PREF_LOCKED_LOCK_SCREEN_ON_EXIT, false);
            if (doLockScreen && (isAdmin = (devicePolicyManager = (DevicePolicyManager)this.getSystemService("device_policy")).isAdminActive(componentName = new ComponentName((Context)this, RSReceiverAdminLockedActivity.class)))) {
                devicePolicyManager.lockNow();
            }
        }
    }
}

