/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.graphics;

import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.util.Log;
import com.risesoftware.graphics.ImageSkewerOptions;

public class ImageSkewer {
    private final String TAG = this.getClass().getSimpleName();
    private Bitmap m_bitmap = null;
    private int m_bitmapHeight = 0;
    private int m_bitmapWidth = 0;
    private int m_bitmapCenterX = 0;
    private int m_bitmapCenterY = 0;
    private Camera m_camera = new Camera();

    public ImageSkewer() {
    }

    public ImageSkewer(@NonNull Bitmap inputBitmap) {
        this.m_bitmap = inputBitmap;
        this.m_bitmapHeight = this.m_bitmap.getHeight();
        this.m_bitmapWidth = this.m_bitmap.getWidth();
        this.m_bitmapCenterY = this.m_bitmapHeight / 2;
        this.m_bitmapCenterX = this.m_bitmapWidth / 2;
    }

    private void resetVariables(Bitmap bitmap) {
        this.m_bitmap = bitmap;
        if (null == this.m_bitmap) {
            return;
        }
        this.m_bitmapHeight = this.m_bitmap.getHeight();
        this.m_bitmapWidth = this.m_bitmap.getWidth();
        this.m_bitmapCenterY = this.m_bitmapHeight / 2;
        this.m_bitmapCenterX = this.m_bitmapWidth / 2;
    }

    private void setBitmap(Bitmap bitmap, ImageSkewerOptions imageSkewerOptions) {
        Bitmap optionsBitmap;
        if (null != bitmap) {
            if (bitmap != this.m_bitmap) {
                this.resetVariables(bitmap);
            }
        } else if (null != imageSkewerOptions.originalBitmap() && (optionsBitmap = imageSkewerOptions.originalBitmap()) != this.m_bitmap) {
            this.resetVariables(optionsBitmap);
        }
    }

    public Bitmap skewImage2D(ImageSkewerOptions imageSkewerOptions) {
        return this.skewImage2D(this.m_bitmap, imageSkewerOptions);
    }

    public Bitmap skewImage2D(Bitmap bitmap, ImageSkewerOptions imageSkewerOptions) {
        this.setBitmap(bitmap, imageSkewerOptions);
        if (null == this.m_bitmap) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(imageSkewerOptions.scaleX(), imageSkewerOptions.scaleY());
        matrix.postSkew(imageSkewerOptions.skewX(), imageSkewerOptions.skewY());
        matrix.postTranslate((float)this.m_bitmapCenterX, (float)this.m_bitmapCenterY);
        Log.d((String)this.TAG, (String)String.format("bitmap = %s, width = %d, height = %d", this.m_bitmap.toString(), this.m_bitmapWidth, this.m_bitmapHeight));
        return Bitmap.createBitmap((Bitmap)this.m_bitmap, (int)0, (int)0, (int)this.m_bitmapWidth, (int)this.m_bitmapHeight, (Matrix)matrix, (boolean)true);
    }

    public Bitmap skewImage3D(ImageSkewerOptions imageSkewerOptions) {
        return this.skewImage3D(this.m_bitmap, imageSkewerOptions);
    }

    public Bitmap skewImage3D(Bitmap bitmap, ImageSkewerOptions imageSkewerOptions) {
        this.setBitmap(bitmap, imageSkewerOptions);
        RectF src = new RectF(0.0f, 0.0f, (float)this.m_bitmapWidth, (float)this.m_bitmapHeight);
        RectF dst = new RectF(src);
        dst.inset(30.0f, 30.0f);
        this.m_camera.save();
        this.m_camera.rotateX(imageSkewerOptions.rotateX());
        this.m_camera.rotateY(imageSkewerOptions.rotateY());
        this.m_camera.rotateZ(imageSkewerOptions.rotateZ());
        Matrix matrix = new Matrix();
        this.m_camera.getMatrix(matrix);
        matrix.preTranslate((float)(-this.m_bitmapCenterX), (float)(-this.m_bitmapCenterY));
        matrix.postTranslate((float)this.m_bitmapCenterX, (float)this.m_bitmapCenterY);
        this.m_camera.restore();
        Log.d((String)this.TAG, (String)String.format("bitmap = %s, width = %d, height = %d", this.m_bitmap.toString(), this.m_bitmapWidth, this.m_bitmapHeight));
        return Bitmap.createBitmap((Bitmap)this.m_bitmap, (int)0, (int)0, (int)this.m_bitmapWidth, (int)this.m_bitmapHeight, (Matrix)matrix, (boolean)true);
    }
}

