/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.utils;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import com.risesoftware.ui.utils.SystemUiHider;
import com.risesoftware.ui.utils.SystemUiHiderIceCreamSandwich;
import com.risesoftware.ui.utils.SystemUiHiderJellyBean;
import com.risesoftware.ui.utils.SystemUiHiderKitKat;

public abstract class SystemUiHiderBase {
    protected Activity m_activity;
    protected View m_anchorView;
    protected int m_showFlags = -1;
    protected int m_hideFlags = -1;
    protected int m_testForHiddenFlags = -1;
    protected boolean m_visible = true;
    protected boolean m_fullscreenLayout = true;
    protected OnVisibilityChangeListener m_onVisibilityChangeListener = DUMMY_LISTENER;
    private static final OnVisibilityChangeListener DUMMY_LISTENER = new OnVisibilityChangeListener(){

        @Override
        public void onVisibilityChange(boolean visible) {
        }
    };

    public static SystemUiHiderBase getInstance(Activity activity, View anchorView) {
        if (19 <= Build.VERSION.SDK_INT) {
            return new SystemUiHiderKitKat(activity, anchorView);
        }
        if (16 <= Build.VERSION.SDK_INT) {
            return new SystemUiHiderJellyBean(activity, anchorView);
        }
        if (14 <= Build.VERSION.SDK_INT) {
            return new SystemUiHiderIceCreamSandwich(activity, anchorView);
        }
        SystemUiHider systemUiHider = new SystemUiHider(activity, anchorView);
        systemUiHider.setup();
        return systemUiHider;
    }

    protected SystemUiHiderBase(Activity activity, View anchorView) {
        this.m_activity = activity;
        this.m_anchorView = anchorView;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public abstract void hide();

    public abstract void show();

    public void toggle() {
        if (this.m_visible) {
            this.hide();
        } else {
            this.show();
        }
    }

    public boolean isFullScreenLayout() {
        return this.m_fullscreenLayout;
    }

    public void toggleFullScreenLayout() {
        if (this.m_fullscreenLayout) {
            this.disableFullScreenLayout();
        } else {
            this.enableFullScreenLayout();
        }
    }

    public abstract void enableFullScreenLayout();

    public abstract void disableFullScreenLayout();

    public void setOnVisibilityChangeListener(OnVisibilityChangeListener listener) {
        OnVisibilityChangeListener listener1 = listener;
        if (null == listener1) {
            listener1 = DUMMY_LISTENER;
        }
        this.m_onVisibilityChangeListener = listener1;
    }

    public static interface OnVisibilityChangeListener {
        public void onVisibilityChange(boolean var1);
    }
}

