/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.graphics;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.util.Log;
import com.risesoftware.utils.logging.RSLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GraphicUtils {
    public static final String TAG = GraphicUtils.class.getSimpleName();

    public static Bitmap drawableToBitmap(Drawable drawable) {
        if (null == drawable) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            Log.i((String)TAG, (String)"Bitmap drawable!");
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int intrinsicWidth = drawable.getIntrinsicWidth();
        int intrinsicHeight = drawable.getIntrinsicHeight();
        if (0 >= intrinsicWidth || 0 >= intrinsicHeight) {
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)intrinsicWidth, (int)intrinsicHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"Encountered OutOfMemoryError while generating bitmap!");
            return null;
        }
    }

    public static File saveBitmapUriToFile(@NonNull Context context, @NonNull Uri uri, int pngQuality, @NonNull String dir, @NonNull String name) {
        Bitmap bitmap;
        try {
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
        }
        catch (IOException e) {
            RSLog.e((String)"saveBitmapUriToFile", (String)e.toString(), (Throwable)e);
            return null;
        }
        return GraphicUtils.storeImage(bitmap, pngQuality, dir, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File storeImage(Bitmap image, int pngQuality, String dir, String name) {
        File pictureFile = GraphicUtils.getOutputMediaFile(dir, name);
        if (null == pictureFile) {
            Log.d((String)TAG, (String)"Error creating media file, check storage permissions: ");
            return null;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pictureFile);
            if (!image.compress(Bitmap.CompressFormat.PNG, pngQuality, (OutputStream)fos)) {
                File file = null;
                return file;
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)e.getMessage(), (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    RSLog.e((String)TAG, (String)e.toString(), (Throwable)e);
                }
            }
        }
        return pictureFile;
    }

    public static Bitmap decodeFile(String fileName, int dstWidth, int dstHeight, ScalingLogic scalingLogic) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)fileName, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        options.inSampleSize = GraphicUtils.calculateSampleSize(options.outWidth, options.outHeight, dstWidth, dstHeight, scalingLogic);
        return BitmapFactory.decodeFile((String)fileName, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeStream(FileInputStream fileInputStream, int dstWidth, int dstHeight, ScalingLogic scalingLogic) {
        try {
            return GraphicUtils.decodeStreamOrThrow(fileInputStream, dstWidth, dstHeight, scalingLogic);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeStreamOrThrow(FileInputStream fileInputStream, int dstWidth, int dstHeight, ScalingLogic scalingLogic) throws IOException {
        BufferedInputStream buf = new BufferedInputStream(fileInputStream, 1024);
        buf.mark(buf.available());
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)buf, null, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        options.inSampleSize = GraphicUtils.calculateSampleSize(options.outWidth, options.outHeight, dstWidth, dstHeight, scalingLogic);
        buf.reset();
        return BitmapFactory.decodeStream((InputStream)buf, null, (BitmapFactory.Options)options);
    }

    public static int calculateSampleSize(int srcWidth, int srcHeight, int dstWidth, int dstHeight, ScalingLogic scalingLogic) {
        if (scalingLogic == ScalingLogic.FIT) {
            float srcAspect = (float)srcWidth / (float)srcHeight;
            float dstAspect = (float)dstWidth / (float)dstHeight;
            if (srcAspect > dstAspect) {
                return srcWidth / dstWidth;
            }
            return srcHeight / dstHeight;
        }
        float srcAspect = (float)srcWidth / (float)srcHeight;
        float dstAspect = (float)dstWidth / (float)dstHeight;
        if (srcAspect > dstAspect) {
            return srcHeight / dstHeight;
        }
        return srcWidth / dstWidth;
    }

    public static Drawable resizeDrawable(Drawable drawable, int newWidth, int newHeight) {
        BitmapDrawable tempDrawable = (BitmapDrawable)drawable;
        if (null == tempDrawable) {
            return null;
        }
        Bitmap bitmapOrg = tempDrawable.getBitmap();
        int width = bitmapOrg.getWidth();
        int height = bitmapOrg.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return new BitmapDrawable(resizedBitmap);
    }

    private static File getOutputMediaFile(@NonNull String dir, @NonNull String name) {
        File directory;
        File mediaStorageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!mediaStorageDir.exists()) {
            boolean bl = mediaStorageDir.mkdirs();
        }
        if (!(directory = new File(mediaStorageDir, dir)).exists()) {
            boolean bl = directory.mkdir();
        }
        return new File(directory, name);
    }

    public static enum ScalingLogic {
        CROP,
        FIT;

    }
}

