/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.widget;

import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.risesoftware.ui.R;

public class RSSlideOutBar
extends LinearLayout
implements View.OnClickListener {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected ImageButton m_btnToggle = null;
    protected boolean m_isToolbarShown = true;
    protected boolean m_doDelayedHide = false;
    protected boolean m_isMeasured = false;
    protected int m_shownXPos = -1;
    protected int m_hiddenXPos = -1;
    protected long m_duration = 750L;
    protected ObjectAnimator m_hideBarAnim = null;
    protected ObjectAnimator m_showBarAnim = null;
    protected View.OnLayoutChangeListener m_onLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            RSSlideOutBar.this.onLayoutChanged(view, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom);
        }
    };

    public RSSlideOutBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public RSSlideOutBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RSSlideOutBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @SuppressLint(value={"NewApi"})
    public RSSlideOutBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.m_btnToggle = new ImageButton(context);
        this.m_btnToggle.setOnClickListener((View.OnClickListener)this);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SlideOutBar, 0, 0);
        try {
            int paddingLeft = typedArray.getDimensionPixelOffset(R.styleable.SlideOutBar_buttonPaddingLeft, 0);
            int paddingRight = typedArray.getDimensionPixelOffset(R.styleable.SlideOutBar_buttonPaddingRight, 0);
            int paddingTop = typedArray.getDimensionPixelOffset(R.styleable.SlideOutBar_buttonPaddingTop, 0);
            int paddingBottom = typedArray.getDimensionPixelOffset(R.styleable.SlideOutBar_buttonPaddingBottom, 0);
            int resId = typedArray.getResourceId(R.styleable.SlideOutBar_buttonImageResource, R.drawable.rs_ic_toolbar_button);
            int backgroundResId = typedArray.getResourceId(R.styleable.SlideOutBar_buttonBackgroundResource, R.color.rs_invisible);
            this.m_btnToggle.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            this.m_btnToggle.setImageResource(resId);
            this.m_btnToggle.setBackgroundResource(backgroundResId);
        }
        finally {
            typedArray.recycle();
        }
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.addView((View)this.m_btnToggle, (ViewGroup.LayoutParams)layoutParams);
        this.addOnLayoutChangeListener(this.m_onLayoutChangeListener);
    }

    public void setAnimationDuration(long duration) {
        this.m_duration = duration;
        if (null != this.m_hideBarAnim) {
            this.m_hideBarAnim.setDuration(this.m_duration);
        }
        if (null != this.m_showBarAnim) {
            this.m_showBarAnim.setDuration(this.m_duration);
        }
    }

    public boolean isToolbarShown() {
        return this.m_isToolbarShown;
    }

    public void onClick(View view) {
        if (this.m_isToolbarShown) {
            this.hideWithAnim();
        } else {
            this.showWithAnim();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        Log.d((String)this.TAG, (String)String.format("onLayoutChanged   left = %d  right = %d ", l, r));
    }

    protected void onLayoutChanged(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        Log.d((String)this.TAG, (String)String.format("onLayoutChanged   left = %d  right = %d ", left, right));
        if (!this.m_isMeasured) {
            this.m_shownXPos = left;
            this.m_hiddenXPos = right - (this.m_btnToggle.getWidth() + this.getPaddingLeft());
            this.m_hideBarAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"x", (float[])new float[]{this.m_hiddenXPos});
            this.m_hideBarAnim.setDuration(this.m_duration);
            this.m_showBarAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"x", (float[])new float[]{this.m_shownXPos});
            this.m_showBarAnim.setDuration(this.m_duration);
            this.m_isMeasured = true;
            if (this.m_doDelayedHide) {
                this.hide();
            }
        }
    }

    public void showWithAnim() {
        if (this.m_isToolbarShown) {
            return;
        }
        if (Build.VERSION.SDK_INT > 13) {
            if (null == this.m_hideBarAnim || null == this.m_showBarAnim) {
                return;
            }
            if (this.m_hideBarAnim.isStarted()) {
                this.m_hideBarAnim.cancel();
            }
            this.m_showBarAnim.start();
        } else {
            this.show();
        }
        this.m_isToolbarShown = true;
    }

    public void hideWithAnim() {
        if (!this.m_isToolbarShown) {
            Log.d((String)this.TAG, (String)"hideWithAnim() is hidden, will not hide.");
            return;
        }
        if (!this.m_isMeasured) {
            this.m_doDelayedHide = true;
        }
        if (Build.VERSION.SDK_INT > 13) {
            if (null == this.m_hideBarAnim || null == this.m_showBarAnim) {
                return;
            }
            if (this.m_showBarAnim.isStarted()) {
                this.m_showBarAnim.cancel();
            }
            this.m_hideBarAnim.start();
        } else {
            this.hide();
        }
        this.m_isToolbarShown = false;
    }

    public void show() {
        Log.d((String)this.TAG, (String)"show");
        if (this.m_isToolbarShown) {
            return;
        }
        Log.d((String)this.TAG, (String)"showing");
        this.m_isToolbarShown = true;
        this.setX(this.m_shownXPos);
    }

    public void hide() {
        Log.d((String)this.TAG, (String)"hide");
        if (!this.m_isToolbarShown) {
            return;
        }
        Log.d((String)this.TAG, (String)"hiding");
        this.m_isToolbarShown = false;
        this.setX(this.m_hiddenXPos);
        this.setLeft(this.m_hiddenXPos);
    }
}

