/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.util;

import android.os.Process;
import android.util.Pair;
import com.riningan.util.LoggerConfig;
import com.riningan.util.MessageType;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class Log {
    private LoggerConfig config;
    private Object mThis = null;
    private final Semaphore mSemaphore = new Semaphore(1, true);
    private final LinkedList<Pair<MessageType, String>> mLogQueue = new LinkedList();

    Log(LoggerConfig config) {
        this.config = config;
    }

    public void debug() {
        String msg = this.getClassAndMethodOfThis();
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String message) {
        String msg = this.getClassAndMethodOfThis() + " - " + message;
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String param, String value) {
        String msg = this.getClassAndMethodOfThis() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String param, int value) {
        String msg = this.getClassAndMethodOfThis() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String param, boolean value) {
        String msg = this.getClassAndMethodOfThis() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String param, long value) {
        String msg = this.getClassAndMethodOfThis() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String param, double value) {
        String msg = this.getClassAndMethodOfThis() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String param, float value) {
        String msg = this.getClassAndMethodOfThis() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void debug(String param, String value, String ... params) {
        StringBuilder msg = new StringBuilder(this.getClassAndMethodOfThis() + "(" + param + " = " + value);
        for (int i = 0; i < params.length - 1; i += 2) {
            msg.append(", ").append(params[i]).append(" = ").append(params[i + 1]);
        }
        if (params.length % 2 == 0) {
            msg.append(")");
        } else {
            msg.append(") - ").append(params[params.length - 1]);
        }
        this.addDebug(msg.toString());
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void error(String message) {
        int line = Thread.currentThread().getStackTrace()[4].getLineNumber();
        String msg = this.getClassAndMethodOfThis() + "(" + Integer.toString(line) + ") - " + message;
        this.addError(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void error(Throwable throwable) {
        int line = Thread.currentThread().getStackTrace()[4].getLineNumber();
        String msg = this.getClassAndMethodOfThis() + "(" + Integer.toString(line) + ") - " + throwable.getMessage();
        this.addError(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void info() {
        String msg = this.getClassAndMethodOfThis();
        this.addInfo(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    public void info(String message) {
        String msg = this.getClassAndMethodOfThis() + " - " + message;
        this.addInfo(msg);
        this.mThis = null;
        this.mSemaphore.release();
    }

    void forThis(Object object) {
        try {
            this.mSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mThis = object;
    }

    void debugThread() {
        String msg = this.getClassAndMethod();
        this.addDebug(msg);
    }

    void debugThread(String message) {
        String msg = this.getClassAndMethod() + " - " + message;
        this.addDebug(msg);
    }

    void debugThread(String param, String value) {
        String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
    }

    void debugThread(String param, int value) {
        String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
    }

    void debugThread(String param, boolean value) {
        String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
    }

    void debugThread(String param, long value) {
        String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
    }

    void debugThread(String param, double value) {
        String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
    }

    void debugThread(String param, float value) {
        String msg = this.getClassAndMethod() + "(" + param + " = " + value + ")";
        this.addDebug(msg);
    }

    void debugThread(String param, String value, String ... params) {
        StringBuilder msg = new StringBuilder(this.getClassAndMethod() + "(" + param + " = " + value);
        for (int i = 0; i < params.length - 1; i += 2) {
            msg.append(", ").append(params[i]).append(" = ").append(params[i + 1]);
        }
        if (params.length % 2 == 0) {
            msg.append(")");
        } else {
            msg.append(") - ").append(params[params.length - 1]);
        }
        this.addDebug(msg.toString());
    }

    void errorThread(String message) {
        int line = Thread.currentThread().getStackTrace()[5].getLineNumber();
        String msg = this.getClassAndMethod() + "(" + Integer.toString(line) + ") - " + message;
        this.addError(msg);
    }

    void errorThread(Throwable throwable) {
        int line = Thread.currentThread().getStackTrace()[5].getLineNumber();
        String msg = this.getClassAndMethod() + "(" + Integer.toString(line) + ") - " + throwable.getMessage();
        this.addError(msg);
    }

    void infoThread() {
        String msg = this.getClassAndMethod();
        this.addInfo(msg);
    }

    void infoThread(String message) {
        String msg = this.getClassAndMethod() + " - " + message;
        this.addInfo(msg);
    }

    private synchronized void addDebug(String message) {
        String fullMessage = this.getPrefix() + ": " + message;
        android.util.Log.d((String)MessageType.DEBUG.name(), (String)fullMessage);
        this.addToQueue(MessageType.DEBUG, fullMessage);
        this.config.onNewMessage(MessageType.DEBUG, fullMessage);
    }

    private synchronized void addError(String message) {
        String fullMessage = this.getPrefix() + ": " + message;
        android.util.Log.e((String)MessageType.ERROR.name(), (String)fullMessage);
        this.addToQueue(MessageType.ERROR, fullMessage);
        this.config.onNewMessage(MessageType.ERROR, fullMessage);
    }

    private synchronized void addInfo(String message) {
        String fullMessage = this.getPrefix() + ": " + message;
        android.util.Log.i((String)MessageType.INFO.name(), (String)fullMessage);
        this.addToQueue(MessageType.INFO, fullMessage);
        this.config.onNewMessage(MessageType.INFO, fullMessage);
    }

    private String getClassAndMethod() {
        String className = Thread.currentThread().getStackTrace()[5].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[5].getMethodName();
        return className.substring(this.config.getApplicationIdLength()) + "." + methodName;
    }

    private String getClassAndMethodOfThis() {
        String className = this.mThis.getClass().getName();
        String methodName = Thread.currentThread().getStackTrace()[4].getMethodName();
        return className.substring(this.config.getApplicationIdLength()) + "." + methodName;
    }

    private String getPrefix() {
        return this.config.getPreffix() + "time(" + this.config.getDateTime() + "): process(" + Process.myPid() + "): thread(" + Thread.currentThread().getId() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(MessageType type, String msg) {
        LinkedList<Pair<MessageType, String>> linkedList = this.mLogQueue;
        synchronized (linkedList) {
            if (this.mLogQueue.size() > 100) {
                this.mLogQueue.removeFirst();
            }
            this.mLogQueue.add((Pair<MessageType, String>)new Pair((Object)type, (Object)msg));
        }
    }
}

