/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.retrofit2.converter.csv;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import okhttp3.ResponseBody;
import retrofit2.Converter;

public final class CsvResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private static final char BACKSLASH = '\\';
    private static final char COMMA = ',';
    private static final char QUOTATION = '\"';
    private Gson mGson;
    private TypeAdapter<T> mAdapter;

    CsvResponseBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.mGson = gson;
        this.mAdapter = adapter;
    }

    public T convert(ResponseBody value) throws IOException {
        String[] rows = value.string().split("\n");
        value.close();
        if (rows.length < 2) {
            throw new IOException("Not valid csv: rows count is less than 2");
        }
        ArrayList<String> titles = this.getValues(rows[0]);
        if (titles.size() < 1) {
            throw new IOException("Not valid csv: columns count is less than 1");
        }
        JsonArray array = new JsonArray();
        for (int i = 1; i < rows.length; ++i) {
            ArrayList<String> values = this.getValues(rows[i]);
            if (values.size() != titles.size()) {
                throw new IOException("Not valid csv: columns count in row " + i + " is not equals to columns count in header's row");
            }
            JsonObject object = new JsonObject();
            for (int j = 0; j < values.size(); ++j) {
                try {
                    object.addProperty(titles.get(j), (Number)Long.parseLong(values.get(j)));
                    continue;
                }
                catch (NumberFormatException ignored1) {
                    try {
                        object.addProperty(titles.get(j), (Number)Double.parseDouble(values.get(j)));
                        continue;
                    }
                    catch (NumberFormatException ignored2) {
                        if (values.get(j).equalsIgnoreCase("true") || values.get(j).equalsIgnoreCase("false")) {
                            object.addProperty(titles.get(j), Boolean.valueOf(values.get(j)));
                            continue;
                        }
                        object.addProperty(titles.get(j), values.get(j));
                    }
                }
            }
            array.add((JsonElement)object);
        }
        String json = array.size() == 1 ? array.get(0).toString() : array.toString();
        StringReader stringReader = new StringReader(json);
        JsonReader jsonReader = this.mGson.newJsonReader((Reader)stringReader);
        return (T)this.mAdapter.read(jsonReader);
    }

    private ArrayList<String> getValues(String row) {
        row = row.trim();
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder value = new StringBuilder();
        boolean open = false;
        boolean backslash = false;
        block5: for (int i = 0; i < row.length(); ++i) {
            char cur = row.charAt(i);
            switch (cur) {
                case '\\': {
                    backslash = true;
                    continue block5;
                }
                case '\"': {
                    if (backslash) {
                        value.append(cur);
                        backslash = false;
                        continue block5;
                    }
                    open = !open;
                    continue block5;
                }
                case ',': {
                    if (backslash) {
                        value.append('\\');
                        backslash = false;
                    }
                    if (open) {
                        value.append(cur);
                        continue block5;
                    }
                    result.add(value.toString());
                    value = new StringBuilder();
                    continue block5;
                }
                default: {
                    if (backslash) {
                        value.append('\\');
                        backslash = false;
                    }
                    value.append(cur);
                }
            }
        }
        if (backslash) {
            value.append('\\');
        }
        result.add(value.toString());
        return result;
    }
}

