/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.retrofit2.converter.csv;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import retrofit2.Converter;

public class CsvRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"text/csv; charset=UTF-8");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private Gson mGson;
    private TypeAdapter<T> mAdapter;

    CsvRequestBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.mGson = gson;
        this.mAdapter = adapter;
    }

    public RequestBody convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        OutputStreamWriter writer = new OutputStreamWriter(buffer.outputStream(), UTF_8);
        JsonWriter jsonWriter = this.mGson.newJsonWriter((Writer)writer);
        this.mAdapter.write(jsonWriter, value);
        jsonWriter.close();
        JsonElement json = (JsonElement)this.mGson.fromJson(buffer.readUtf8(), JsonElement.class);
        ArrayList<Map<String, String>> valuesList = this.getValuesList(json);
        for (int i = 1; i < valuesList.size(); ++i) {
            Map<String, String> previousValues = valuesList.get(i - 1);
            Map<String, String> currentValues = valuesList.get(i);
            if (previousValues.keySet().equals(currentValues.keySet())) continue;
            throw new IOException("Not equals elements: " + String.valueOf(i - 1) + " and " + i);
        }
        StringBuilder csv = new StringBuilder();
        ArrayList<String> titles = new ArrayList<String>();
        for (Map.Entry<String, String> entry : valuesList.get(0).entrySet()) {
            if (csv.length() > 0) {
                csv.append(",");
            }
            titles.add(entry.getKey());
            csv.append(entry.getKey());
        }
        csv.append("\n");
        for (Map map : valuesList) {
            csv.append((String)map.get(titles.get(0)));
            for (int i = 1; i < titles.size(); ++i) {
                csv.append(",").append((String)map.get(titles.get(i)));
            }
            csv.append("\n");
        }
        return RequestBody.create((MediaType)MEDIA_TYPE, (String)csv.toString().trim());
    }

    private ArrayList<Map<String, String>> getValuesList(JsonElement json) throws IOException {
        ArrayList<Map<String, String>> valuesList = new ArrayList<Map<String, String>>();
        if (json.isJsonArray()) {
            JsonArray jsonArray = (JsonArray)json;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                if (!jsonElement.isJsonObject()) {
                    throw new IOException("Not valid json array element: " + jsonElement.toString());
                }
                valuesList.add(this.getValues((JsonObject)jsonElement));
            }
            if (valuesList.size() == 0) {
                throw new IOException("Not valid json array: " + json.toString());
            }
        } else if (json.isJsonObject()) {
            valuesList.add(this.getValues((JsonObject)json));
        } else {
            throw new IOException("Not valid json type: " + json.toString());
        }
        return valuesList;
    }

    private Map<String, String> getValues(JsonObject jsonObject) throws IOException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = (JsonPrimitive)entry.getValue();
                if (jsonPrimitive.isNumber()) {
                    values.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber().toString());
                    continue;
                }
                if (jsonPrimitive.isString()) {
                    values.put((String)entry.getKey(), "\"" + ((JsonElement)entry.getValue()).getAsString() + "\"");
                    continue;
                }
                if (jsonPrimitive.isBoolean()) {
                    values.put((String)entry.getKey(), String.valueOf(((JsonElement)entry.getValue()).getAsBoolean()));
                    continue;
                }
                throw new IOException("Not valid json object primitive value: " + ((JsonElement)entry.getValue()).toString());
            }
            throw new IOException("Not valid json object value: " + ((JsonElement)entry.getValue()).toString());
        }
        if (values.size() == 0) {
            throw new IOException("Not valid json to convert csv: " + jsonObject.toString());
        }
        return values;
    }
}

