/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.retrofit2.converter.csv;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.riningan.retrofit2.converter.csv.CsvRequestBodyConverter;
import com.riningan.retrofit2.converter.csv.CsvResponseBodyConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public final class CsvConverterFactory
extends Converter.Factory {
    private final Gson mGson;

    public static CsvConverterFactory create() {
        return new CsvConverterFactory(new Gson());
    }

    public static CsvConverterFactory create(Gson gson) {
        if (gson == null) {
            throw new NullPointerException("gson == null");
        }
        return new CsvConverterFactory(gson);
    }

    private CsvConverterFactory(Gson gson) {
        this.mGson = gson;
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        TypeAdapter adapter = this.mGson.getAdapter(TypeToken.get((Type)type));
        return new CsvRequestBodyConverter(this.mGson, adapter);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        TypeAdapter adapter = this.mGson.getAdapter(TypeToken.get((Type)type));
        return new CsvResponseBodyConverter(this.mGson, adapter);
    }
}

