/*
 * Decompiled with CFR 0.152.
 */
package com.ringcentral.pubnub;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.enums.PNReconnectionPolicy;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNMembershipResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNSpaceResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNUserResult;
import com.ringcentral.RestClient;
import com.ringcentral.RestException;
import com.ringcentral.definitions.CreateSubscriptionRequest;
import com.ringcentral.definitions.NotificationDeliveryModeRequest;
import com.ringcentral.definitions.SubscriptionInfo;
import com.ringcentral.pubnub.EventListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class Subscription {
    private String[] eventFilters;
    private RestClient restClient;
    private SubscribeCallback callback;
    private SubscriptionInfo _subscription;
    private Timer timer;
    private PubNub pubnub;

    public Subscription(RestClient restClient, String[] eventFilters, final EventListener eventListener) {
        this.restClient = restClient;
        this.eventFilters = eventFilters;
        this.callback = new SubscribeCallback(){

            public void status(PubNub pubnub, PNStatus pnStatus) {
            }

            public void presence(PubNub pubnub, PNPresenceEventResult pnPresenceEventResult) {
            }

            public void signal(PubNub pubnub, PNSignalResult pnSignalResult) {
            }

            public void user(PubNub pubnub, PNUserResult pnUserResult) {
            }

            public void space(PubNub pubnub, PNSpaceResult pnSpaceResult) {
            }

            public void membership(PubNub pubnub, PNMembershipResult pnMembershipResult) {
            }

            public void messageAction(PubNub pubnub, PNMessageActionResult pnMessageActionResult) {
            }

            public void message(PubNub pubnub, PNMessageResult pnMessageResult) {
                byte[] decrypted;
                if (eventListener == null) {
                    return;
                }
                byte[] encrypted = Base64.getDecoder().decode(pnMessageResult.getMessage().getAsString());
                byte[] encryptionKey = Base64.getDecoder().decode(Subscription.this.getSubscription().deliveryMode.encryptionKey);
                try {
                    Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
                    cipher.init(2, new SecretKeySpec(encryptionKey, "AES"));
                    decrypted = cipher.doFinal(encrypted);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    e.printStackTrace();
                    return;
                }
                String jsonString = new String(decrypted, StandardCharsets.UTF_8);
                eventListener.listen(jsonString);
            }
        };
    }

    public SubscriptionInfo getSubscription() {
        return this._subscription;
    }

    void setSubscription(SubscriptionInfo subscription) {
        this._subscription = subscription;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (subscription != null) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        Subscription.this.refresh();
                    }
                    catch (RestException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, (subscription.expiresIn - 120L) * 1000L);
        }
    }

    public void subscribe() throws RestException, IOException {
        SubscriptionInfo subscriptionInfo = this.restClient.restapi().subscription().post(this.getPostParameters());
        this.setSubscription(subscriptionInfo);
        PNConfiguration pnConfiguration = new PNConfiguration();
        pnConfiguration.setReconnectionPolicy(PNReconnectionPolicy.LINEAR);
        pnConfiguration.setSubscribeKey(this.getSubscription().deliveryMode.subscriberKey);
        this.pubnub = new PubNub(pnConfiguration);
        this.pubnub.addListener(this.callback);
        this.pubnub.subscribe().channels(Collections.singletonList(this.getSubscription().deliveryMode.address)).execute();
    }

    public void refresh() throws RestException, IOException {
        if (this.getSubscription() == null) {
            return;
        }
        SubscriptionInfo subscriptionInfo = this.restClient.restapi().subscription(this.getSubscription().id).renew().post();
        this.setSubscription(subscriptionInfo);
    }

    public void revoke() throws RestException, IOException {
        if (this.getSubscription() == null) {
            return;
        }
        try {
            this.restClient.restapi().subscription(this.getSubscription().id).delete();
        }
        catch (RestException re) {
            if (re.response.code() == 404) {
                return;
            }
            throw re;
        }
        finally {
            this.pubnub.destroy();
            this.pubnub = null;
            this.setSubscription(null);
        }
    }

    private CreateSubscriptionRequest getPostParameters() {
        return new CreateSubscriptionRequest().deliveryMode(new NotificationDeliveryModeRequest().transportType("PubNub").encryption(Boolean.valueOf(true))).eventFilters(this.eventFilters);
    }
}

