/*
 * Decompiled with CFR 0.152.
 */
package com.rimerosolutions.ant.wrapper.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;

public class AntWrapperTask
extends Task {
    static final String TASK_DESCRIPTION = "Generate Ant Command Line Wrapper";
    static final int BUFFER_SIZE = 1024;
    static final String DEFAULT_BASE_DISTRIBUTION_URL = "http://archive.apache.org/dist/ant/binaries";
    static final String ANT_VERSION_FILE_LOCATION = "/org/apache/tools/ant/version.txt";
    static final String ANT_VERSION_PROPERTY = "VERSION";
    static final String FILE_URL_SCHEME = "file";
    static final String ANT_WRAPPER_PROPERTIES_FILE_COMMENTS = "Ant download properties";
    public static final String ANT_BIN_FILENAME_TEMPLATE = "apache-ant-%s-bin.zip";
    public static final String WRAPPER_ROOT_FOLDER_NAME = "wrapper";
    public static final String WRAPPER_PROPERTIES_FILE_NAME = "wrapper.properties";
    public static final String WRAPPER_JAR_FILE_NAME = "wrapper.jar";
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String LAUNCHER_WINDOWS_FILE_NAME = "antw.bat";
    public static final String LAUNCHER_WINDOWSCMD_FILE_NAME = "antw.cmd";
    public static final String LCP_WINDOWS_FILE_NAME = "lcp.bat";
    public static final String LAUNCHER_UNIX_FILE_NAME = "antw";
    static final String RESOURCES_LOCATION = "com/rimerosolutions/ant/wrapper";
    static final String[] LAUNCHER_RESOURCES = new String[]{"antw.bat", "antw.cmd", "lcp.bat", "antw"};
    private String baseDistributionUrl;
    private String antVersion;

    public void setAntVersion(String antVersion) {
        this.antVersion = antVersion;
    }

    public void setBaseDistributionUrl(String baseDistributionUrl) {
        this.baseDistributionUrl = baseDistributionUrl;
    }

    public String getDescription() {
        return TASK_DESCRIPTION;
    }

    public void execute() throws BuildException {
        this.copyScripts();
        this.writeWrapperPropertiesFile();
    }

    private void copyScripts() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        for (String launcherFileName : LAUNCHER_RESOURCES) {
            URL launcherUrl = classLoader.getResource("com/rimerosolutions/ant/wrapper/" + launcherFileName);
            File launcherFile = new File(this.getProject().getBaseDir(), launcherFileName);
            try {
                AntWrapperTask.copyResourceToFile((Resource)new FileResource(new File(launcherUrl.getFile())), launcherFile);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            if (launcherFile.setExecutable(true)) continue;
            this.log("Could not set executable flag on file: " + launcherFile.getAbsolutePath());
        }
    }

    private void writeWrapperPropertiesFile() {
        File wrapperSupportDir = new File(this.getProject().getBaseDir(), WRAPPER_ROOT_FOLDER_NAME);
        this.ensureWrapperSupportDirExists(wrapperSupportDir);
        AntWrapperTask.copyResourceToFile((Resource)new FileResource(this.findWrapperJarFile()), new File(wrapperSupportDir, WRAPPER_JAR_FILE_NAME));
        FileOutputStream propertiesOutputStream = null;
        try {
            File file = new File(wrapperSupportDir, WRAPPER_PROPERTIES_FILE_NAME);
            Properties props = new Properties();
            props.put(DISTRIBUTION_URL_PROPERTY, this.buildDistributionUrl());
            propertiesOutputStream = new FileOutputStream(file);
            props.store(propertiesOutputStream, ANT_WRAPPER_PROPERTIES_FILE_COMMENTS);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Unable to store wrapper properties", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtils.close(propertiesOutputStream);
                throw throwable;
            }
        }
        FileUtils.close((OutputStream)propertiesOutputStream);
    }

    private void ensureWrapperSupportDirExists(File wrapperSupportDir) {
        if (!wrapperSupportDir.exists()) {
            wrapperSupportDir.mkdirs();
        }
    }

    private String buildDistributionUrl() {
        StringBuilder binaryFileLocation = new StringBuilder(248);
        if (this.baseDistributionUrl == null) {
            this.baseDistributionUrl = DEFAULT_BASE_DISTRIBUTION_URL;
        }
        binaryFileLocation.append(this.baseDistributionUrl);
        if (!this.baseDistributionUrl.endsWith("/")) {
            binaryFileLocation.append('/');
        }
        binaryFileLocation.append(ANT_BIN_FILENAME_TEMPLATE);
        if (this.antVersion == null || this.antVersion.trim().length() == 0) {
            this.antVersion = AntWrapperTask.getAntRuntimeVersion();
        }
        return String.format(binaryFileLocation.toString(), this.antVersion);
    }

    protected File findWrapperJarFile() {
        URI location;
        try {
            location = AntWrapperTask.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
        if (!location.getScheme().equals(FILE_URL_SCHEME)) {
            throw new BuildException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        return new File(location.getPath());
    }

    private static void copyResourceToFile(Resource r, File f) {
        Copy copy = new Copy();
        copy.setProject(new Project());
        copy.add((ResourceCollection)r);
        copy.setTofile(f);
        copy.execute();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getAntRuntimeVersion() throws BuildException {
        String string;
        block6: {
            InputStream in = null;
            try {
                Properties props = new Properties();
                in = AntWrapperTask.class.getResourceAsStream(ANT_VERSION_FILE_LOCATION);
                props.load(in);
                string = props.getProperty(ANT_VERSION_PROPERTY);
                if (in == null) break block6;
            }
            catch (IOException ioe) {
                try {
                    throw new BuildException("Could not load the version information:" + ioe.getMessage());
                    catch (NullPointerException npe) {
                        throw new BuildException("Could not load the Apache Ant version information.");
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        FileUtils.close(in);
                    }
                    throw throwable;
                }
            }
            FileUtils.close((InputStream)in);
        }
        return string;
    }
}

