/*
 * Decompiled with CFR 0.152.
 */
package com.rimerosolutions.ant.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemPropertiesHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getSystemProperties(File propertiesFile) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (!propertiesFile.isFile()) {
            return propertyMap;
        }
        Properties properties = new Properties();
        try {
            FileInputStream inStream = new FileInputStream(propertiesFile);
            try {
                properties.load(inStream);
            }
            finally {
                inStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error when loading properties file=" + propertiesFile, e);
        }
        Pattern pattern = Pattern.compile("systemProp\\.(.*)");
        for (Object argument : properties.keySet()) {
            String key;
            Matcher matcher = pattern.matcher(argument.toString());
            if (!matcher.find() || (key = matcher.group(1)).length() <= 0) continue;
            propertyMap.put(key, properties.get(argument).toString());
        }
        return propertyMap;
    }
}

