/*
 * Decompiled with CFR 0.152.
 */
package com.rimerosolutions.ant.wrapper;

import com.rimerosolutions.ant.wrapper.Downloader;
import com.rimerosolutions.ant.wrapper.PathAssembler;
import com.rimerosolutions.ant.wrapper.WrapperConfiguration;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Installer {
    public static final String DEFAULT_DISTRIBUTION_PATH = "wrapper/dists";
    private final Downloader download;
    private final PathAssembler pathAssembler;

    public Installer(Downloader download, PathAssembler pathAssembler) {
        this.download = download;
        this.pathAssembler = pathAssembler;
    }

    public File createDist(WrapperConfiguration configuration) throws Exception {
        URI distributionUrl = configuration.getDistribution();
        boolean alwaysDownload = configuration.isAlwaysDownload();
        boolean alwaysUnpack = configuration.isAlwaysUnpack();
        PathAssembler.LocalDistribution localDistribution = this.pathAssembler.getDistribution(configuration);
        File localZipFile = localDistribution.getZipFile();
        boolean downloaded = false;
        if (alwaysDownload || !localZipFile.exists()) {
            File tmpZipFile = new File(localZipFile.getParentFile(), localZipFile.getName() + ".part");
            tmpZipFile.delete();
            System.out.println("Downloading " + distributionUrl);
            this.download.download(distributionUrl, tmpZipFile);
            tmpZipFile.renameTo(localZipFile);
            downloaded = true;
        }
        File distDir = localDistribution.getDistributionDir();
        List<File> dirs = this.listDirs(distDir);
        if (downloaded || alwaysUnpack || dirs.isEmpty()) {
            for (File dir : dirs) {
                System.out.println("Deleting directory " + dir.getAbsolutePath());
                this.deleteDir(dir);
            }
            System.out.println("Unzipping " + localZipFile.getAbsolutePath() + " to " + distDir.getAbsolutePath());
            this.unzip(localZipFile, distDir);
            dirs = this.listDirs(distDir);
            if (dirs.isEmpty()) {
                throw new RuntimeException(String.format("Ant distribution '%s' does not contain any directories. Expected to find exactly 1 directory.", distributionUrl));
            }
            this.setExecutablePermissions(dirs.get(0));
        }
        if (dirs.size() != 1) {
            throw new RuntimeException(String.format("Ant distribution '%s' contains too many directories. Expected to find exactly 1 directory.", distributionUrl));
        }
        return dirs.get(0);
    }

    private List<File> listDirs(File distDir) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (distDir.exists()) {
            for (File file : distDir.listFiles()) {
                if (!file.isDirectory()) continue;
                dirs.add(file);
            }
        }
        return dirs;
    }

    private void setExecutablePermissions(File appHome) {
        if (this.isWindows()) {
            return;
        }
        File appCommand = new File(appHome, "bin/ant");
        String errorMessage = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("chmod", "755", appCommand.getCanonicalPath());
            Process p = pb.start();
            if (p.waitFor() == 0) {
                System.out.println("Set executable permissions for: " + appCommand.getAbsolutePath());
            } else {
                String line;
                BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
                Formatter stdout = new Formatter();
                while ((line = is.readLine()) != null) {
                    stdout.format("%s%n", line);
                }
                errorMessage = stdout.toString();
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (InterruptedException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null) {
            System.out.println("Could not set executable permissions for: " + appCommand.getAbsolutePath());
            System.out.println("Please do this manually if you want to use ant.");
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void unzip(File zip, File dest) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(dest, entry.getName()).mkdirs();
                continue;
            }
            this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(dest, entry.getName()))));
        }
        zipFile.close();
    }

    public void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

