/*
 * Decompiled with CFR 0.152.
 */
package com.rimerosolutions.ant.wrapper;

import com.rimerosolutions.ant.wrapper.BootstrapMainStarter;
import com.rimerosolutions.ant.wrapper.DefaultDownloader;
import com.rimerosolutions.ant.wrapper.Installer;
import com.rimerosolutions.ant.wrapper.PathAssembler;
import com.rimerosolutions.ant.wrapper.SystemPropertiesHandler;
import com.rimerosolutions.ant.wrapper.WrapperExecutor;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class AntWrapperMain {
    public static final String DEFAULT_ANT_USER_HOME = System.getProperty("user.home") + "/.ant";

    public static void main(String[] args) throws Exception {
        File defaultAntUserHomeDir = new File(DEFAULT_ANT_USER_HOME);
        if (!defaultAntUserHomeDir.exists()) {
            defaultAntUserHomeDir.mkdirs();
        }
        File wrapperJar = AntWrapperMain.wrapperJar();
        File propertiesFile = AntWrapperMain.wrapperProperties(wrapperJar);
        File rootDir = AntWrapperMain.rootDir(wrapperJar);
        AntWrapperMain.addSystemProperties(rootDir);
        WrapperExecutor wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile(propertiesFile, System.out);
        wrapperExecutor.execute(args, new Installer(new DefaultDownloader("antw", AntWrapperMain.wrapperVersion()), new PathAssembler(AntWrapperMain.antUserHome())), new BootstrapMainStarter());
    }

    private static void addSystemProperties(File rootDir) {
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(AntWrapperMain.antUserHome(), "ant.properties")));
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(rootDir, "ant.properties")));
    }

    private static File rootDir(File wrapperJar) {
        return wrapperJar.getParentFile().getParentFile().getParentFile();
    }

    private static File wrapperProperties(File wrapperJar) {
        return new File(wrapperJar.getParent(), wrapperJar.getName().replaceFirst("\\.jar$", ".properties"));
    }

    private static File wrapperJar() {
        URI location;
        try {
            location = AntWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new RuntimeException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        return new File(location.getPath());
    }

    static String wrapperVersion() {
        return "1.0";
    }

    private static File antUserHome() {
        String antUserHome = System.getProperty("ANT_USER_HOME");
        if (antUserHome != null) {
            return new File(antUserHome);
        }
        antUserHome = System.getenv("ANT_USER_HOME");
        if (antUserHome != null) {
            return new File(antUserHome);
        }
        return new File(DEFAULT_ANT_USER_HOME);
    }
}

