/*
   Copyright (c) 2012 Emitrom LLC. All rights reserved. 
   For licensing questions, please contact us at licensing@emitrom.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package com.emitrom.lienzo.client.core.event;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;

public abstract class AbstractNodeMouseEvent<T extends MouseEvent<?>, H extends EventHandler> extends GwtEvent<H> implements INodeXYEvent
{
    private final int m_x;

    private final int m_y;
    
    private final T m_event;

    public static class Type<H> extends GwtEvent.Type<H>
    {

    }
    
    protected AbstractNodeMouseEvent(T event)
    {
    	m_x = event.getRelativeX(event.getRelativeElement());
    	
    	m_y = event.getRelativeY(event.getRelativeElement());
    	
    	m_event = event;
    }

    protected AbstractNodeMouseEvent(int x, int y)
    {
        m_x = x;

        m_y = y;
        
        m_event = null;
    }

    @Override
    public int getX()
    {
        return m_x;
    }

    @Override
    public int getY()
    {
        return m_y;
    }
   
    @Override
    public GwtEvent<?> getNodeEvent()
    {
        return this;
    }
    
    /**
     * The native event that was initially generated by the DOM.
     * 
     * @return
     */
    public T getMouseEvent()
    {
    	return m_event;
    }
    
    public boolean isButtonLeft()
    {
    	if (null != m_event)
    	{
    		if (m_event.getNativeButton() == NativeEvent.BUTTON_LEFT)
    		{
    			return true;
    		}
    	}
    	return false;
    }
    
    public boolean isButtonMiddle()
    {
    	if (null != m_event)
    	{
    		if (m_event.getNativeButton() == NativeEvent.BUTTON_MIDDLE)
    		{
    			return true;
    		}
    	}
    	return false;
    }

    public boolean isButtonRight()
    {
        if (null != m_event)
        {
            if (m_event.getNativeButton() == NativeEvent.BUTTON_RIGHT)
            {
                return true;
            }
        }
        return false;
    }

    public boolean isControlKeyDown()
    {
        return (null != m_event) && m_event.isControlKeyDown();
    }

    public boolean isShiftKeyDown()
    {
        return (null != m_event) && m_event.isShiftKeyDown();
    }

    public boolean isAltKeyDown()
    {
        return (null != m_event) && m_event.isAltKeyDown();
    }

    public boolean isMetaKeyDown()
    {
        return (null != m_event) && m_event.isMetaKeyDown();
    }
}
