/*
 * Decompiled with CFR 0.152.
 */
package com.revosleap.blurrylayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.core.content.ContextCompat;
import com.revosleap.blurrylayout.GaussianBlur;
import com.revosleap.blurrylayout.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0007J\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001b\u001a\u00020\u0011H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/revosleap/blurrylayout/BlurryLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_IMAGE", "Landroid/graphics/drawable/Drawable;", "imageDrawable", "imageView", "Landroid/widget/ImageView;", "linearLayout", "Landroid/widget/LinearLayout;", "blurColor", "", "blurOpacity", "bluropacity", "", "setBitmapBlur", "bitmapBlur", "Landroid/graphics/Bitmap;", "radius", "blurPercentage", "setDrawableBlur", "setImageBg", "Companion", "blurrylayout_release"})
public final class BlurryLayout
extends FrameLayout {
    private final LinearLayout linearLayout;
    private final ImageView imageView;
    private final Drawable imageDrawable;
    private Drawable DEFAULT_IMAGE;
    private static final int DEFAULT_BLUR_COLOR = -1;
    private static int BLUR_COLOR;
    private static final int DEFAULT_BLUR_RADIUS = 10;
    private static int BLUR_RADIUS;
    private static final float DEFAULT_ALPHA = 0.3f;
    private static float ALPHA;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    private final void setImageBg() {
        Drawable bg = null;
        if (this.imageDrawable != null) {
            this.setDrawableBlur(this.imageDrawable);
        } else {
            bg = this.DEFAULT_IMAGE;
            Drawable drawable = bg;
            if (!(drawable instanceof BitmapDrawable)) {
                drawable = null;
            }
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable;
            Bitmap image = bitmapDrawable != null ? bitmapDrawable.getBitmap() : null;
            try {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                Bitmap bitmap = image;
                if (bitmap == null) {
                    Intrinsics.throwNpe();
                }
                this.imageView.setImageBitmap(GaussianBlur.INSTANCE.blurred(context, bitmap, BLUR_RADIUS));
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        this.linearLayout.setBackgroundColor(BLUR_COLOR);
        this.linearLayout.setAlpha(ALPHA);
    }

    public final void blurColor(int blurColor) {
        this.linearLayout.setBackgroundColor(blurColor);
    }

    public final void blurOpacity(float bluropacity) {
        this.linearLayout.setAlpha(bluropacity);
    }

    public final void setDrawableBlur(@NotNull Drawable imageDrawable, int radius, int blurPercentage) {
        Bitmap image;
        Intrinsics.checkParameterIsNotNull((Object)imageDrawable, (String)"imageDrawable");
        Bitmap bitmap = image = ((BitmapDrawable)imageDrawable).getBitmap();
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"image");
        int height = bitmap.getHeight();
        int width = image.getWidth();
        Bitmap background = ThumbnailUtils.extractThumbnail((Bitmap)image, (int)(width * blurPercentage / 100), (int)(height * blurPercentage / 100));
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Bitmap bitmap2 = background;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"background");
        this.imageView.setImageBitmap(GaussianBlur.INSTANCE.blurred(context, bitmap2, radius));
    }

    public final void setDrawableBlur(@NotNull Drawable imageDrawable, int radius) {
        Intrinsics.checkParameterIsNotNull((Object)imageDrawable, (String)"imageDrawable");
        this.setDrawableBlur(imageDrawable, radius, 10);
    }

    public final void setDrawableBlur(@NotNull Drawable imageDrawable) {
        Intrinsics.checkParameterIsNotNull((Object)imageDrawable, (String)"imageDrawable");
        this.setDrawableBlur(imageDrawable, 10, 10);
    }

    public final void setBitmapBlur(@NotNull Bitmap bitmapBlur, int radius, int blurPercentage) {
        Intrinsics.checkParameterIsNotNull((Object)bitmapBlur, (String)"bitmapBlur");
        int height = bitmapBlur.getHeight();
        int width = bitmapBlur.getWidth();
        Bitmap bg = ThumbnailUtils.extractThumbnail((Bitmap)bitmapBlur, (int)(width * blurPercentage / 100), (int)(height * blurPercentage / 100));
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Bitmap bitmap = bg;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"bg");
        this.imageView.setImageBitmap(GaussianBlur.INSTANCE.blurred(context, bitmap, radius));
    }

    public final void setBitmapBlur(@NotNull Bitmap bitmapBlur, int radius) {
        Intrinsics.checkParameterIsNotNull((Object)bitmapBlur, (String)"bitmapBlur");
        this.setBitmapBlur(bitmapBlur, radius, 10);
    }

    public final void setBitmapBlur(@NotNull Bitmap bitmapBlur) {
        Intrinsics.checkParameterIsNotNull((Object)bitmapBlur, (String)"bitmapBlur");
        this.setBitmapBlur(bitmapBlur, 10, 10);
    }

    @JvmOverloads
    public BlurryLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)R.layout.blurry_layout, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.linearLayout);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.linearLayout)");
        this.linearLayout = (LinearLayout)view;
        View view2 = this.findViewById(R.id.imageView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.imageView)");
        this.imageView = (ImageView)view2;
        this.DEFAULT_IMAGE = ContextCompat.getDrawable((Context)context, (int)R.drawable.image);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BlurryLayout, defStyleAttr, 0);
        BLUR_COLOR = typedArray.getColor(R.styleable.BlurryLayout_blurColor, DEFAULT_BLUR_COLOR);
        ALPHA = typedArray.getFloat(R.styleable.BlurryLayout_blurOpacity, DEFAULT_ALPHA);
        BLUR_RADIUS = typedArray.getInt(R.styleable.BlurryLayout_blurRadius, DEFAULT_BLUR_RADIUS);
        this.imageDrawable = typedArray.getDrawable(R.styleable.BlurryLayout_blurImage);
        typedArray.recycle();
        this.setImageBg();
    }

    @JvmOverloads
    public /* synthetic */ BlurryLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BlurryLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BlurryLayout(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_BLUR_COLOR = -1;
        DEFAULT_BLUR_RADIUS = 10;
        BLUR_RADIUS = 10;
        DEFAULT_ALPHA = 0.3f;
        ALPHA = 10.0f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/revosleap/blurrylayout/BlurryLayout$Companion;", "", "()V", "ALPHA", "", "BLUR_COLOR", "", "BLUR_RADIUS", "DEFAULT_ALPHA", "DEFAULT_BLUR_COLOR", "DEFAULT_BLUR_RADIUS", "blurrylayout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

