/*
 * Decompiled with CFR 0.152.
 */
package com.revosleap.blurrylayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.revosleap.blurrylayout.GaussianBlur;
import com.revosleap.blurrylayout.R;

public class BlurryLayout
extends FrameLayout {
    private LinearLayout linearLayout;
    private ImageView imageView;
    private static int DEFAULT_BLUR_COLOR = -1;
    private static int BLUR_COLOR;
    private static int DEFAULT_BLUR_RADIUS;
    private static int BLUR_RADIUS;
    private static float DEFAULT_ALPHA;
    private static float ALPHA;
    private Drawable imageDrawable;
    Drawable DEFAULT_IMAGE;

    public BlurryLayout(@NonNull Context context) {
        this(context, null);
    }

    public BlurryLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BlurryLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        BlurryLayout.inflate((Context)context, (int)R.layout.blurry_layout, (ViewGroup)this);
        this.linearLayout = (LinearLayout)this.findViewById(R.id.linearLayout);
        this.imageView = (ImageView)this.findViewById(R.id.imageView);
        this.DEFAULT_IMAGE = this.getResources().getDrawable(R.drawable.image);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BlurryLayout, defStyleAttr, 0);
        BLUR_COLOR = typedArray.getColor(R.styleable.BlurryLayout_blurColor, DEFAULT_BLUR_COLOR);
        ALPHA = typedArray.getFloat(R.styleable.BlurryLayout_blurOpacity, DEFAULT_ALPHA);
        BLUR_RADIUS = typedArray.getInt(R.styleable.BlurryLayout_blurRadius, DEFAULT_BLUR_RADIUS);
        this.imageDrawable = typedArray.getDrawable(R.styleable.BlurryLayout_blurImage);
        typedArray.recycle();
        this.setImageBg();
    }

    private void setImageBg() {
        if (this.imageDrawable != null) {
            this.blurBackground(this.imageDrawable, BLUR_RADIUS);
        } else {
            Drawable bg = this.DEFAULT_IMAGE;
            Bitmap image = ((BitmapDrawable)bg).getBitmap();
            this.imageView.setImageBitmap(GaussianBlur.blurred(this.getContext(), image, BLUR_RADIUS));
        }
        this.linearLayout.setBackgroundColor(BLUR_COLOR);
        this.linearLayout.setAlpha(ALPHA);
    }

    public void blurColor(int blurColor) {
        this.linearLayout.setBackgroundColor(blurColor);
    }

    public void blurOpacity(float bluropacity) {
        this.linearLayout.setAlpha(bluropacity);
    }

    public void blurBackground(Drawable imageDr, int radius) {
        Bitmap image = ((BitmapDrawable)imageDr).getBitmap();
        int height = image.getHeight();
        int width = image.getWidth();
        Bitmap background = ThumbnailUtils.extractThumbnail((Bitmap)image, (int)(height * 3 / 100), (int)(width * 3 / 100));
        this.imageView.setImageBitmap(GaussianBlur.blurred(this.getContext(), background, radius));
    }

    static {
        DEFAULT_BLUR_RADIUS = 10;
        DEFAULT_ALPHA = 0.3f;
    }
}

