/*
 * Decompiled with CFR 0.152.
 */
package com.revosleap.blurrylayout;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.revosleap.blurrylayout.GaussianBlur;
import com.revosleap.blurrylayout.R;

public class BlurryLayout
extends FrameLayout {
    private LinearLayout linearLayout;
    private ImageView imageView;

    public BlurryLayout(@NonNull Context context) {
        this(context, null);
    }

    public BlurryLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BlurryLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        BlurryLayout.inflate((Context)context, (int)R.layout.blurry_layout, (ViewGroup)this);
        this.linearLayout = (LinearLayout)this.findViewById(R.id.linearLayout);
        this.imageView = (ImageView)this.findViewById(R.id.imageView);
        this.linearLayout.setBackgroundColor(-1);
        this.linearLayout.setAlpha(0.3f);
    }

    public void blurBackground(Bitmap image, int blurRadius) {
        int height = image.getHeight();
        int width = image.getWidth();
        Bitmap background = ThumbnailUtils.extractThumbnail((Bitmap)image, (int)(height * 3 / 100), (int)(width * 3 / 100));
        this.imageView.setImageBitmap(GaussianBlur.blurred(this.getContext(), background, blurRadius));
    }

    public void blurColor(int blurColor) {
        this.linearLayout.setBackgroundColor(blurColor);
    }

    public void blurOpacity(float bluropacity) {
        this.linearLayout.setAlpha(bluropacity);
    }
}

