/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.gen.exc.ReqlAuthError;
import com.rethinkdb.net.Crypto;
import java.util.Optional;

public class ScramAttributes {
    Optional<String> _authIdentity = Optional.empty();
    Optional<String> _username = Optional.empty();
    Optional<String> _nonce = Optional.empty();
    Optional<String> _headerAndChannelBinding = Optional.empty();
    Optional<byte[]> _salt = Optional.empty();
    Optional<Integer> _iterationCount = Optional.empty();
    Optional<String> _clientProof = Optional.empty();
    Optional<byte[]> _serverSignature = Optional.empty();
    Optional<String> _error = Optional.empty();
    Optional<String> _originalString = Optional.empty();

    public static ScramAttributes create() {
        return new ScramAttributes();
    }

    static ScramAttributes from(ScramAttributes other) {
        ScramAttributes out = new ScramAttributes();
        out._authIdentity = other._authIdentity;
        out._username = other._username;
        out._nonce = other._nonce;
        out._headerAndChannelBinding = other._headerAndChannelBinding;
        out._salt = other._salt;
        out._iterationCount = other._iterationCount;
        out._clientProof = other._clientProof;
        out._serverSignature = other._serverSignature;
        out._error = other._error;
        return out;
    }

    static ScramAttributes from(String input) {
        ScramAttributes sa = new ScramAttributes();
        sa._originalString = Optional.of(input);
        for (String section : input.split(",")) {
            String[] keyVal = section.split("=", 2);
            sa.setAttribute(keyVal[0], keyVal[1]);
        }
        return sa;
    }

    private void setAttribute(String key, String val) {
        switch (key) {
            case "a": {
                this._authIdentity = Optional.of(val);
                break;
            }
            case "n": {
                this._username = Optional.of(val);
                break;
            }
            case "r": {
                this._nonce = Optional.of(val);
                break;
            }
            case "m": {
                throw new ReqlAuthError("m field disallowed");
            }
            case "c": {
                this._headerAndChannelBinding = Optional.of(val);
                break;
            }
            case "s": {
                this._salt = Optional.of(Crypto.fromBase64(val));
                break;
            }
            case "i": {
                this._iterationCount = Optional.of(Integer.parseInt(val));
                break;
            }
            case "p": {
                this._clientProof = Optional.of(val);
                break;
            }
            case "v": {
                this._serverSignature = Optional.of(Crypto.fromBase64(val));
                break;
            }
            case "e": {
                this._error = Optional.of(val);
                break;
            }
        }
    }

    public String toString() {
        if (this._originalString.isPresent()) {
            return this._originalString.get();
        }
        String output = "";
        if (this._username.isPresent()) {
            output = output + ",n=" + this._username.get();
        }
        if (this._nonce.isPresent()) {
            output = output + ",r=" + this._nonce.get();
        }
        if (this._headerAndChannelBinding.isPresent()) {
            output = output + ",c=" + this._headerAndChannelBinding.get();
        }
        if (this._clientProof.isPresent()) {
            output = output + ",p=" + this._clientProof.get();
        }
        if (output.startsWith(",")) {
            return output.substring(1);
        }
        return output;
    }

    ScramAttributes username(String username) {
        ScramAttributes next = ScramAttributes.from(this);
        next._username = Optional.of(username.replace("=", "=3D").replace(",", "=2C"));
        return next;
    }

    ScramAttributes nonce(String nonce) {
        ScramAttributes next = ScramAttributes.from(this);
        next._nonce = Optional.of(nonce);
        return next;
    }

    ScramAttributes headerAndChannelBinding(String hacb) {
        ScramAttributes next = ScramAttributes.from(this);
        next._headerAndChannelBinding = Optional.of(hacb);
        return next;
    }

    ScramAttributes clientProof(byte[] clientProof) {
        ScramAttributes next = ScramAttributes.from(this);
        next._clientProof = Optional.of(Crypto.toBase64(clientProof));
        return next;
    }

    String authIdentity() {
        return this._authIdentity.get();
    }

    String username() {
        return this._username.get();
    }

    String nonce() {
        return this._nonce.get();
    }

    String headerAndChannelBinding() {
        return this._headerAndChannelBinding.get();
    }

    byte[] salt() {
        return this._salt.get();
    }

    Integer iterationCount() {
        return this._iterationCount.get();
    }

    String clientProof() {
        return this._clientProof.get();
    }

    byte[] serverSignature() {
        return this._serverSignature.get();
    }

    String error() {
        return this._error.get();
    }
}

