/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.gen.ast.Datum;
import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.model.GroupedResult;
import com.rethinkdb.model.MapObject;
import com.rethinkdb.model.OptArgs;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Converter {
    private static final Base64.Decoder b64decoder = Base64.getMimeDecoder();
    private static final Base64.Encoder b64encoder = Base64.getMimeEncoder();
    public static final String PSEUDOTYPE_KEY = "$reql_type$";
    public static final String TIME = "TIME";
    public static final String GROUPED_DATA = "GROUPED_DATA";
    public static final String GEOMETRY = "GEOMETRY";
    public static final String BINARY = "BINARY";

    public static Object convertPseudotypes(Object obj, FormatOptions fmt) {
        if (obj instanceof List) {
            return ((List)obj).stream().map(item -> Converter.convertPseudotypes(item, fmt)).collect(Collectors.toList());
        }
        if (obj instanceof Map) {
            Map mapobj = (Map)obj;
            if (mapobj.containsKey(PSEUDOTYPE_KEY)) {
                return Converter.convertPseudo(mapobj, fmt);
            }
            return mapobj.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(entry.getKey(), Converter.convertPseudotypes(entry.getValue(), fmt)), HashMap::putAll);
        }
        return obj;
    }

    public static Object convertPseudo(Map<String, Object> value, FormatOptions fmt) {
        String reqlType;
        if (value == null) {
            return null;
        }
        switch (reqlType = (String)value.get(PSEUDOTYPE_KEY)) {
            case "TIME": {
                return fmt.rawTime ? value : Converter.getTime(value);
            }
            case "GROUPED_DATA": {
                return fmt.rawGroups ? value : Converter.getGrouped(value);
            }
            case "BINARY": {
                return fmt.rawBinary ? value : (Object)Converter.getBinary(value);
            }
            case "GEOMETRY": {
                return value;
            }
        }
        return value;
    }

    private static List<GroupedResult> getGrouped(Map<String, Object> value) {
        return ((List)value.get("data")).stream().map(g -> new GroupedResult(g.remove(0), g)).collect(Collectors.toList());
    }

    private static OffsetDateTime getTime(Map<String, Object> obj) {
        try {
            ZoneOffset offset = ZoneOffset.of((String)obj.get("timezone"));
            Double epochTime = ((Number)obj.get("epoch_time")).doubleValue();
            Instant timeInstant = Instant.ofEpochMilli(Double.valueOf(epochTime * 1000.0).longValue());
            return OffsetDateTime.ofInstant(timeInstant, offset);
        }
        catch (Exception ex) {
            throw new ReqlDriverError("Error handling date", ex);
        }
    }

    private static byte[] getBinary(Map<String, Object> value) {
        String str = (String)value.get("data");
        return b64decoder.decode(str);
    }

    public static Map<String, Object> toBinary(byte[] data) {
        MapObject mob = new MapObject();
        mob.with(PSEUDOTYPE_KEY, BINARY);
        mob.with("data", b64encoder.encodeToString(data));
        return mob;
    }

    public static class FormatOptions {
        public final boolean rawTime;
        public final boolean rawGroups;
        public final boolean rawBinary;

        public FormatOptions(OptArgs args) {
            this.rawTime = args.getOrDefault((Object)"time_format", new Datum((Object)"native")).datum.equals("raw");
            this.rawBinary = args.getOrDefault((Object)"binary_format", new Datum((Object)"native")).datum.equals("raw");
            this.rawGroups = args.getOrDefault((Object)"group_format", new Datum((Object)"native")).datum.equals("raw");
        }
    }
}

