/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.async.Deferred;
import com.restlet.client.async.Promise;
import com.restlet.client.async.PromiseHandler;
import com.restlet.client.async.Promises;
import com.restlet.client.async.impl.DeferredImpl;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Executor;
import com.restlet.client.function.Predicate;
import com.restlet.client.function.Supplier;
import com.restlet.client.log.LogService;
import com.restlet.client.utils.Nullable;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.util.LinkedList;
import java.util.Queue;

public class TaskQueue {
    private final String title;
    private final LogService logService;
    private final Queue<TaskConfiguration> queue = new LinkedList<TaskConfiguration>();

    private TaskQueue(String title, LogService logService) {
        this.title = title;
        this.logService = logService;
    }

    public static TaskQueue newTaskQueue(String title, LogService logService) {
        return new TaskQueue(title, logService);
    }

    public <T> Promise<T> addToQueue(String taskTitle, Supplier<Promise<T>> newPromiseSupplier) {
        return this.addToQueue(TaskConfiguration.newTaskConfiguration(taskTitle, newPromiseSupplier));
    }

    public <T> Promise<T> addToQueue(final TaskConfiguration<T> taskConfiguration) {
        boolean hasAlreadyOneUniqueTaskStacked;
        if (taskConfiguration.type == Type.UNIQUE && (hasAlreadyOneUniqueTaskStacked = Sequence.of(this.queue).some(new Predicate<TaskConfiguration>(){

            @Override
            public boolean test(TaskConfiguration stackedTask) {
                return stackedTask.type == Type.UNIQUE && Objects.equals(stackedTask.name, taskConfiguration.name);
            }
        }))) {
            return Promises.of();
        }
        taskConfiguration.taskExecutor = this.getTaskExecutor(taskConfiguration);
        boolean shouldRun = this.queue.isEmpty();
        this.queue.add(taskConfiguration);
        if (shouldRun) {
            taskConfiguration.taskExecutor.execute();
        }
        return taskConfiguration.deferredResult.promise();
    }

    private <T> Executor getTaskExecutor(final TaskConfiguration<T> taskConfiguration) {
        return new Executor(){

            @Override
            public void execute() {
                TaskQueue.this.logService.debug(TaskQueue.class, StringUtils.format("%s BEGIN: %s", TaskQueue.this.title, taskConfiguration.name));
                taskConfiguration.taskPromiseSupplier.get().doOnResolve(new Consumer<T>(){

                    @Override
                    public void consume(T whatever) {
                        taskConfiguration.deferredResult.resolve(whatever);
                        TaskQueue.this.logService.debug(TaskQueue.class, StringUtils.format("%s END: %s", TaskQueue.this.title, taskConfiguration.name));
                    }
                }).recoverOnReject(new PromiseHandler<Throwable>(){

                    @Override
                    public Object on(@Nullable Throwable error) {
                        taskConfiguration.deferredResult.reject(error);
                        TaskQueue.this.logService.error(StringUtils.format("%s ERROR: %s", TaskQueue.this.title, taskConfiguration.name), error);
                        return null;
                    }
                }).doFinally(new Consumer<Deferred>(){

                    @Override
                    public void consume(Deferred whatever) {
                        TaskQueue.this.queue.poll();
                        if (!TaskQueue.this.queue.isEmpty()) {
                            ((TaskConfiguration)((TaskQueue)TaskQueue.this).queue.peek()).taskExecutor.execute();
                        }
                    }
                });
            }
        };
    }

    public static class TaskConfiguration<T> {
        final Type type;
        final String name;
        final Supplier<Promise<T>> taskPromiseSupplier;
        final Deferred<T> deferredResult = new DeferredImpl();
        Executor taskExecutor;

        private TaskConfiguration(String name, Type type, Supplier<Promise<T>> taskPromiseSupplier) {
            this.type = type;
            this.name = name;
            this.taskPromiseSupplier = taskPromiseSupplier;
        }

        static <T> TaskConfiguration<T> newTaskConfiguration(String name, Supplier<Promise<T>> taskPromiseSupplier) {
            return TaskConfiguration.newTaskConfiguration(name, Type.STANDARD, taskPromiseSupplier);
        }

        public static <T> TaskConfiguration<T> newTaskConfiguration(String name, Type type, Supplier<Promise<T>> taskPromiseSupplier) {
            return new TaskConfiguration<T>(name, type, taskPromiseSupplier);
        }
    }

    public static enum Type {
        STANDARD,
        UNIQUE;

    }
}

