/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.function.Function;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.NotNull;
import com.restlet.client.utils.Objects;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class StringUtils {
    private static final String FORMAT_PLACEHOLDER = "%s";

    public static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean containsIgnoringCase(String container, String contained) {
        if (container == null) {
            return false;
        }
        if (StringUtils.isBlank(contained)) {
            return true;
        }
        return container.toLowerCase().contains(contained.toLowerCase());
    }

    public static int getUTF8StringByteCount(@NotNull String str) {
        int n = str.length();
        int byteCount = 0;
        int i = 0;
        while (i < n) {
            int ch = str.codePointAt(i);
            i += Character.charCount(ch);
            if (ch < 128) {
                ++byteCount;
                continue;
            }
            if (ch < 2048) {
                byteCount += 2;
                continue;
            }
            if (ch < 65536) {
                byteCount += 3;
                continue;
            }
            if (ch < 0x200000) {
                byteCount += 4;
                continue;
            }
            if (ch >= 0x4000000) continue;
            byteCount += 5;
        }
        return byteCount;
    }

    public static String truncate(String description, int i) {
        if (StringUtils.isBlank(description)) {
            return "";
        }
        if (description.length() > i) {
            return description.substring(0, i - 4).concat("\n...");
        }
        return description;
    }

    public static String firstUpper(String string) {
        if (!StringUtils.isBlank(string)) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static boolean oneNotBlank(String ... values) {
        for (String value : values) {
            if (StringUtils.isBlank(value)) continue;
            return true;
        }
        return false;
    }

    public static Maybe<String> firstNotBlank(String ... strings) {
        return StringUtils.firstNotBlank(Arrays.asList(strings));
    }

    public static Maybe<String> firstNotBlank(List<String> strings) {
        for (String s : strings) {
            if (StringUtils.isBlank(s)) continue;
            return Maybe.of(s.trim());
        }
        return Maybe.empty();
    }

    @Deprecated
    public static String firstNotNull(String ... strings) {
        for (String string : strings) {
            if (string == null) continue;
            return string;
        }
        throw new IllegalArgumentException("One input at least should be non-null");
    }

    public static String trimLeft(String string, char charToTrim) {
        if (StringUtils.isBlank(string)) {
            return string;
        }
        return string.replaceFirst("^" + charToTrim + "+", "");
    }

    private static <T> Function<T, String> toStringFunction() {
        return new Function<T, String>(){

            @Override
            public String apply(T input) {
                if (input == null) {
                    return null;
                }
                return input instanceof String ? (String)input : input.toString();
            }
        };
    }

    public static <T> Joiner joiner(List<T> parts) {
        return new Joiner(new AsStringIterator<T>(parts.iterator(), StringUtils.toStringFunction()));
    }

    @SafeVarargs
    public static <T> Joiner joiner(T ... parts) {
        return new Joiner(new AsStringIterator<T>(Arrays.asList(parts).iterator(), StringUtils.toStringFunction()));
    }

    public static <T> Joiner joiner(Iterable<T> parts, Function<T, String> toString) {
        return new Joiner(new AsStringIterator<T>(parts.iterator(), toString));
    }

    public static String padLeft(String value, int length, char c) {
        if (value == null) {
            value = "";
        }
        if (value.length() >= length) {
            return value;
        }
        char[] tab = new char[length - value.length()];
        Arrays.fill(tab, c);
        return new String(tab) + value;
    }

    public static String format(String source, Object ... replacements) {
        Objects.requireNonNull(replacements);
        String result = source;
        for (Object replacement : replacements) {
            int indexOfPlaceholder = result.indexOf(FORMAT_PLACEHOLDER);
            if (indexOfPlaceholder == -1) {
                throw new IllegalArgumentException("Missing placeholder");
            }
            result = result.substring(0, indexOfPlaceholder) + replacement.toString() + result.substring(indexOfPlaceholder + FORMAT_PLACEHOLDER.length());
        }
        if (result.contains(FORMAT_PLACEHOLDER)) {
            throw new IllegalArgumentException("At least one placeholder had no value, current state is " + result);
        }
        return result;
    }

    public static String addPrefixIfMissing(String prefix, String input) {
        return input.startsWith(prefix) ? input : prefix + input;
    }

    private static class AsStringIterator<T>
    implements Iterator<String> {
        private final Iterator<T> wrappedIterator;
        private final Function<T, String> toString;

        AsStringIterator(Iterator<T> wrappedIterator, Function<T, String> toString) {
            this.wrappedIterator = wrappedIterator;
            this.toString = toString;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public String next() {
            return this.toString.apply(this.wrappedIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class Joiner {
        private final Iterator<String> iterator;

        private Joiner(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        public String joinWith(String separator) {
            StringBuilder joined = new StringBuilder();
            if (this.iterator.hasNext()) {
                joined.append(this.iterator.next());
            }
            while (this.iterator.hasNext()) {
                joined.append(separator).append(this.iterator.next());
            }
            return joined.toString();
        }
    }
}

