/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.function.BiConsumer;
import com.restlet.client.function.BiFunction;
import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Nullable;
import com.restlet.client.utils.SequenceTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Sequence<T>
implements Iterable<T> {
    protected final Iterable<T> baseIterable;

    public Sequence(Iterable<T> baseIterable) {
        this.baseIterable = Objects.requireNonNull(baseIterable);
    }

    public static <R> Sequence<R> of(Iterable<R> iterable) {
        return Sequence.ofNullable(iterable);
    }

    @SafeVarargs
    public static <R> Sequence<R> of(R ... iterable) {
        return Sequence.ofNullable(Arrays.asList(iterable));
    }

    private static <R> Sequence<R> ofNullable(@Nullable Iterable<R> iterable) {
        return new Sequence(iterable == null ? Collections.emptyList() : iterable);
    }

    public <R> Sequence<R> map(final Function<T, R> mapper) {
        return new Sequence(this){

            @Override
            public Iterator iterator() {
                final Iterator iterator = this.baseIterable.iterator();
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    public R next() {
                        return mapper.apply(iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove is not supported");
                    }
                };
            }
        };
    }

    public <R> Sequence<R> flatMap(final Function<T, Iterable<R>> mapper) {
        return new Sequence(this){

            @Override
            public Iterator iterator() {
                return new FlatteningIterator(this.baseIterable.iterator(), mapper);
            }
        };
    }

    public void each(BiConsumer<T, Integer> consumer) {
        int i = 0;
        for (T t : this) {
            consumer.consume((Integer)t, i++);
        }
    }

    public <K> Map<K, List<T>> groupBy(Function<T, K> keyProvider) {
        HashMap<K, ArrayList<T>> groupedMap = new HashMap<K, ArrayList<T>>();
        for (T t : this) {
            K key = keyProvider.apply(t);
            ArrayList<T> value = (ArrayList<T>)groupedMap.get(key);
            if (value == null) {
                value = new ArrayList<T>();
                groupedMap.put(key, value);
            }
            value.add(t);
        }
        return groupedMap;
    }

    public boolean some(Predicate<T> predicate) {
        return this.filter(predicate).count() > 0;
    }

    public boolean someEqual(final T valueToCheck) {
        return this.some(new Predicate<T>(){

            @Override
            public boolean test(T element) {
                return Objects.equals(valueToCheck, element);
            }
        });
    }

    public boolean has(final T expectedValue) {
        return this.fastReturn(new Predicate<T>(){

            @Override
            public boolean test(T actualValue) {
                return Objects.equals(actualValue, expectedValue);
            }
        });
    }

    private boolean fastReturn(Predicate<T> returnOn) {
        for (T element : this.baseIterable) {
            if (!returnOn.test(element)) continue;
            return true;
        }
        return false;
    }

    public boolean none(Predicate<T> predicate) {
        return !this.some(predicate);
    }

    public boolean some() {
        return this.count() > 0;
    }

    public boolean all(Predicate<T> predicate) {
        return this.filter(predicate).count() == this.count();
    }

    public List<T> toList() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : this) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public Set<T> toSet() {
        HashSet<T> set = new HashSet<T>();
        for (T t : this) {
            set.add(t);
        }
        return set;
    }

    public int count() {
        int count = 0;
        for (T t : this) {
            ++count;
        }
        return count;
    }

    public Maybe<T> first() {
        Iterator<T> iterator = this.iterator();
        if (iterator.hasNext()) {
            return Maybe.ofNullable(iterator.next());
        }
        return Maybe.empty();
    }

    public <K, V> Map<K, V> toMap(Function<T, K> key, Function<T, V> value) {
        HashMap<K, V> returnValue = new HashMap<K, V>();
        for (T t : this) {
            returnValue.put(key.apply(t), value.apply(t));
        }
        return returnValue;
    }

    public <K, V> Map<K, List<V>> toEmptyMultiValueMap(Function<T, K> keyGetter) {
        HashMap resultMap = new HashMap();
        for (T t : this.toSet()) {
            K key = keyGetter.apply(t);
            resultMap.put(key, new ArrayList());
        }
        return resultMap;
    }

    public <K, V> Map<K, List<V>> toMultiValueMap(Function<T, K> keyGetter, Function<T, V> valueGetter) {
        HashMap resultMap = new HashMap();
        for (T t : this) {
            K key = keyGetter.apply(t);
            V value = valueGetter.apply(t);
            if (!resultMap.containsKey(key)) {
                resultMap.put(key, new ArrayList());
            }
            ((List)resultMap.get(key)).add(value);
        }
        return resultMap;
    }

    @Override
    public Iterator<T> iterator() {
        return this.baseIterable.iterator();
    }

    public Sequence<T> omit(final Predicate<T> predicate) {
        final Sequence originalIterator = this;
        return new Sequence<T>(this){

            @Override
            public Iterator<T> iterator() {
                return new FilteringIterator(predicate, originalIterator.iterator(), FilteringOption.INVERTED);
            }
        };
    }

    public Sequence<T> filter(final Predicate<T> predicate) {
        final Sequence originalIterator = this;
        return new Sequence<T>(this){

            @Override
            public Iterator<T> iterator() {
                return new FilteringIterator(predicate, originalIterator.iterator(), FilteringOption.NON_INVERTED);
            }
        };
    }

    public Maybe<T> find(Predicate<T> predicate) {
        for (T element : this.baseIterable) {
            if (!predicate.test(element)) continue;
            return Maybe.ofNullable(element);
        }
        return Maybe.empty();
    }

    public Sequence<T> omitNulls() {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T item) {
                return item != null;
            }
        });
    }

    public Sequence<T> omitNonNulls() {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T item) {
                return item == null;
            }
        });
    }

    <R> Sequence<R> filterType(final Class<R> expectedType) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return value != null && value.getClass() == expectedType;
            }
        }).map(new Function<T, R>(){

            @Override
            public R apply(T input) {
                return input;
            }
        });
    }

    public <R> R reduce(BiFunction<R, T, R> reducer, R seed) {
        R nextSeed = seed;
        for (T t : this) {
            nextSeed = reducer.apply(nextSeed, t);
        }
        return nextSeed;
    }

    public Sequence<T> removeDuplicates() {
        final LinkedHashSet uniqueElements = new LinkedHashSet();
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T element) {
                return uniqueElements.add(element);
            }
        });
    }

    public SequenceTuple<T> splitOnPredicate(Predicate<T> predicate) {
        return new SequenceTuple<T>(this.filter(predicate), this.omit(predicate));
    }

    public Sequence<T> reverse() {
        ArrayList<T> reversed = new ArrayList<T>();
        for (T element : this.baseIterable) {
            reversed.add(0, element);
        }
        return Sequence.ofNullable(reversed);
    }

    public Sequence<T> takeLeft(final int maxIndex) {
        boolean isNegative;
        boolean bl = isNegative = maxIndex < 0;
        if (isNegative) {
            throw new IllegalArgumentException("Expected positive integer");
        }
        final ArrayList newIterable = new ArrayList();
        this.each(new BiConsumer<T, Integer>(){

            @Override
            public void consume(T element, Integer index) {
                if (newIterable.size() < maxIndex) {
                    newIterable.add(element);
                }
            }
        });
        return Sequence.ofNullable(newIterable);
    }

    public Sequence<T> takeRight(int maxIndex) {
        boolean isNegative;
        boolean bl = isNegative = maxIndex < 0;
        if (isNegative) {
            throw new IllegalArgumentException("Expected positive integer");
        }
        return this.reverse().takeLeft(maxIndex);
    }

    public Sequence<T> dropLeft(final int beginningIndex) {
        boolean isNegative;
        boolean bl = isNegative = beginningIndex < 0;
        if (isNegative) {
            throw new IllegalArgumentException("Expected positive integer");
        }
        final ArrayList newIterable = new ArrayList();
        this.each(new BiConsumer<T, Integer>(){

            @Override
            public void consume(T element, Integer index) {
                if (index >= beginningIndex) {
                    newIterable.add(element);
                }
            }
        });
        return Sequence.ofNullable(newIterable);
    }

    public Sequence<T> dropRight(int beginningIndex) {
        boolean isNegative;
        boolean bl = isNegative = beginningIndex < 0;
        if (isNegative) {
            throw new IllegalArgumentException("Expected positive integer");
        }
        return this.reverse().dropLeft(beginningIndex);
    }

    private static class FilteringIterator<T>
    implements Iterator<T> {
        final Predicate<T> filter;
        final Iterator<T> baseIterator;
        private final boolean invertFilter;
        T nextValue;
        boolean hasNextValue = false;

        FilteringIterator(Predicate<T> filter, Iterator<T> baseIterator, FilteringOption filteringOption) {
            this.filter = filter;
            this.baseIterator = baseIterator;
            this.invertFilter = filteringOption == FilteringOption.INVERTED;
        }

        boolean shouldReturnNextValue(T nextValue) {
            if (this.invertFilter) {
                return !this.filter.test(nextValue);
            }
            return this.filter.test(nextValue);
        }

        void ensureNextValue() {
            if (!this.hasNextValue) {
                while (this.baseIterator.hasNext()) {
                    T next = this.baseIterator.next();
                    if (!this.shouldReturnNextValue(next)) continue;
                    this.nextValue = next;
                    this.hasNextValue = true;
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.ensureNextValue();
            return this.hasNextValue;
        }

        @Override
        public T next() {
            this.ensureNextValue();
            if (!this.hasNextValue) {
                throw new IllegalStateException("Iterator is over");
            }
            T valueToReturn = this.nextValue;
            this.nextValue = null;
            this.hasNextValue = false;
            return valueToReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum FilteringOption {
        INVERTED,
        NON_INVERTED;

    }

    protected static class FlatteningIterator<R, T>
    implements Iterator<R> {
        final Iterator<T> sourceIterable;
        final Function<T, Iterable<R>> flatFunction;
        Iterator<R> currentIterator;

        public FlatteningIterator(Iterator<T> sourceIterable, Function<T, Iterable<R>> flatFunction) {
            this.sourceIterable = sourceIterable;
            this.flatFunction = flatFunction;
        }

        private void trySetupNextIterator() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.sourceIterable.hasNext()) {
                    Iterable<R> result = this.flatFunction.apply(this.sourceIterable.next());
                    if (result == null) continue;
                    this.currentIterator = result.iterator();
                    if (!this.currentIterator.hasNext()) continue;
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.trySetupNextIterator();
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public R next() {
            this.trySetupNextIterator();
            if (this.currentIterator == null) {
                throw new IllegalStateException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

