/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class Objects {
    public static <T> boolean isNullOrEmpty(Collection<T> object) {
        return object == null || object.isEmpty();
    }

    public static <T, E> boolean isNullOrEmpty(Map<T, E> object) {
        return object == null || object.isEmpty();
    }

    public static boolean isNullOrEmpty(String stringParameter) {
        return stringParameter == null || stringParameter.isEmpty();
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        throw new IllegalArgumentException("Expected at least one non null parameter");
    }

    private static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Expected at least one non-null parameter.");
        }
        return object;
    }

    public static String firstNonBlank(String ... values) {
        for (String value : values) {
            if (StringUtils.isBlank(value)) continue;
            return value;
        }
        throw new IllegalArgumentException("Expected at least one non blank parameter");
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <T> boolean contains(T[] elements, T element) {
        return Arrays.asList(elements).contains(element);
    }

    public static boolean areNotNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return false;
        }
        return true;
    }
}

