/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListUtils {
    public static <C> List<C> reverse(List<C> list) {
        return Sequence.of(list).reverse().toList();
    }

    public static <T extends Comparable<T>> List<T> sort(Collection<T> versions) {
        ArrayList<T> orderedVersions = new ArrayList<T>(versions);
        Collections.sort(orderedVersions);
        return orderedVersions;
    }

    @SafeVarargs
    public static <T> List<T> join(List<T> ... lists) {
        ArrayList<T> joinedLists = new ArrayList<T>();
        for (List<T> list : lists) {
            joinedLists.addAll(list);
        }
        return joinedLists;
    }

    public static <T> T last(List<T> elements) {
        Maybe<T> maybeLast = Sequence.of(elements).takeRight(1).first();
        return maybeLast.isPresent() ? (T)maybeLast.get() : null;
    }

    public static <T> T first(Collection<T> elements) {
        Maybe<T> maybeFirst = Sequence.of(elements).takeLeft(1).first();
        return maybeFirst.isPresent() ? (T)maybeFirst.get() : null;
    }

    public static <T> List<T> newFilledList(int size, T fillWith) {
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(fillWith);
        }
        return result;
    }

    public static <T> List<T> add(List<T> input, int index, T element) {
        if (index < 0 || index > input.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == input.size()) {
            input.add(element);
            return input;
        }
        ArrayList<T> endOfList = new ArrayList<T>(input.subList(index, input.size()));
        while (input.size() > index) {
            input.remove(index);
        }
        input.add(element);
        input.addAll(endOfList);
        return input;
    }
}

