/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.utils.Maybe;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Iterables {
    public static <T> Maybe<T> getFirst(Iterable<T> iterable) {
        if (iterable == null) {
            return Maybe.empty();
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return Maybe.of(iterator.next());
        }
        return Maybe.empty();
    }

    public static <T> T getLast(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                throw new NoSuchElementException();
            }
            return Iterables.getLastInNonemptyList(list);
        }
        return Iterables.getLast(iterable.iterator());
    }

    private static <T> T getLastInNonemptyList(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T current;
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }
}

