/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.async.Promise;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.html.form.FormItemTo;
import com.restlet.client.html.form.FormItemType;
import com.restlet.client.html.form.FormTo;
import com.restlet.client.model.EntityTo;
import com.restlet.client.model.EntityTreeNode;
import com.restlet.client.model.UpdateType;
import com.restlet.client.model.environment.EnvironmentTo;
import com.restlet.client.model.environment.EnvironmentVariableTo;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.tests.ScenarioTo;
import com.restlet.client.tests.asserts.AssertionResultTo;
import com.restlet.client.tests.asserts.AssertionTo;
import com.restlet.client.utils.ComparatorUtils;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.NotNull;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class EntityUtils {
    public static final Comparator<EntityTo> ENTITY_COMPARATOR = new Comparator<EntityTo>(){

        @Override
        public int compare(EntityTo entity1, EntityTo entity2) {
            int typeComparison = -EntityTo.Type.getEntityTypeComparator().compare(entity1.getType(), entity2.getType());
            return typeComparison == 0 ? entity1.getName().compareTo(entity2.getName()) : typeComparison;
        }
    };
    public static final Comparator<EntityTreeNode> ENTITY_TREE_NODE_COMPARATOR = new Comparator<EntityTreeNode>(){

        @Override
        public int compare(EntityTreeNode entityTreeNode1, EntityTreeNode entityTreeNode2) {
            return ENTITY_COMPARATOR.compare(entityTreeNode1.entity, entityTreeNode2.entity);
        }
    };

    public static Maybe<EntityTo> getRootEntity(EntityTo entity) {
        for (EntityTo result = entity; result != null; result = result.getParent()) {
            if (result.getParent() != null) continue;
            return Maybe.of(result);
        }
        return Maybe.ofNullable(null);
    }

    public static Maybe<EntityTo> getParent(EntityTo entity, EntityTo.Type type) {
        for (EntityTo result = entity; result != null; result = result.getParent()) {
            if (result.getType() != type) continue;
            return Maybe.of(result);
        }
        return Maybe.ofNullable(null);
    }

    public static EntityTreeNode recursiveFindParents(EntityTo parent) {
        return EntityUtils.recursiveFindParents(null, parent);
    }

    public static EntityTreeNode recursiveFindParents(EntityTreeNode preparedTreeNode, EntityTo parent) {
        if (parent == null) {
            return preparedTreeNode;
        }
        EntityTreeNode wrappedTreeNode = new EntityTreeNode(parent, UpdateType.None, new EntityTreeNode[0]);
        wrappedTreeNode.addChild(preparedTreeNode);
        return EntityUtils.recursiveFindParents(wrappedTreeNode, parent.getParent());
    }

    private static boolean contains(EnvironmentTo environment, final String variableName) {
        return Sequence.of(environment.getVariables()).some(new Predicate<EnvironmentVariableTo>(){

            @Override
            public boolean test(EnvironmentVariableTo environmentVariable) {
                return Objects.equals(variableName, environmentVariable.getName());
            }
        });
    }

    public static boolean addEnvironmentVariable(EnvironmentTo environment, EnvironmentVariableTo variable) {
        List<EnvironmentVariableTo> variables = environment.getVariables();
        if (variables == null) {
            variables = new ArrayList<EnvironmentVariableTo>();
            environment.setVariables(variables);
        }
        if (EntityUtils.contains(environment, variable.getName())) {
            return false;
        }
        variables.add(variable);
        return true;
    }

    public static int indexOf(ScenarioTo scenarioTo, EntityTo request) {
        return request == null ? -1 : EntityUtils.indexOf(scenarioTo, request.getName());
    }

    public static int indexOf(ScenarioTo scenarioTo, String requestName) {
        return scenarioTo.getRequestOrder() == null ? -1 : scenarioTo.getRequestOrder().indexOf(requestName);
    }

    public static boolean equalById(EntityTo entity1, EntityTo entity2) {
        if (entity1 == null) {
            return entity2 == null;
        }
        if (entity2 == null) {
            return false;
        }
        return Objects.equals(entity1.getId(), entity2.getId());
    }

    public static boolean isEnabled(AssertionTo assertion) {
        return assertion.isEnabled() == null || assertion.isEnabled() != false;
    }

    public static boolean isEnabled(AssertionResultTo assertionResult) {
        return assertionResult.isEnabled() == null || assertionResult.isEnabled() != false;
    }

    public static String generateDottedName(@NotNull EntityTo entity) {
        StringBuilder dottedName = new StringBuilder();
        String name = entity.getName();
        dottedName.append(name);
        for (EntityTo parent = entity.getParent(); parent != null; parent = parent.getParent()) {
            dottedName.insert(0, ".");
            dottedName.insert(0, parent.getName());
        }
        return dottedName.toString();
    }

    public static boolean isScenario(EntityTo entityTo) {
        return entityTo instanceof ScenarioTo;
    }

    public static void walkParents(EntityTo entityTo, Consumer<EntityTo> parentVisitor) {
        EntityUtils.walkParents(entityTo, parentVisitor, false);
    }

    public static void walkEntityAndParents(EntityTo entityTo, Consumer<EntityTo> visitor) {
        EntityUtils.walkParents(entityTo, visitor, true);
    }

    private static void walkParents(EntityTo entityTo, Consumer<EntityTo> visitor, boolean visitCurrentEntity) {
        if (entityTo == null) {
            return;
        }
        if (visitCurrentEntity) {
            visitor.consume(entityTo);
        }
        for (EntityTo parent = entityTo.getParent(); parent != null; parent = parent.getParent()) {
            visitor.consume(parent);
        }
    }

    public static String detectEncoding(FormTo formTo) {
        return formTo.getEncoding() != null ? formTo.getEncoding().trim() : EntityUtils.detectEncoding(formTo.getItems());
    }

    public static String detectEncoding(List<FormItemTo> items) {
        if (Sequence.of(items).some(new Predicate<FormItemTo>(){

            @Override
            public boolean test(FormItemTo formItemTo) {
                return FormItemType.File == formItemTo.getType();
            }
        })) {
            return "multipart/form-data";
        }
        return "application/x-www-form-urlencoded";
    }

    public static Promise<List<HttpRequestTo>> getHttpRequests(RepositoryDao repositoryDao, final ScenarioTo scenarioTo) {
        return repositoryDao.filter(EntityTo.Type.Request, scenarioTo).map(new Function<List<EntityTo>, List<HttpRequestTo>>(){

            @Override
            public List<HttpRequestTo> apply(List<EntityTo> input) {
                List<HttpRequestTo> requests = Sequence.of(input).map(new Function<EntityTo, HttpRequestTo>(){

                    @Override
                    public HttpRequestTo apply(EntityTo request) {
                        return (HttpRequestTo)request;
                    }
                }).toList();
                ComparatorUtils.sortHttpRequests(scenarioTo, requests);
                return requests;
            }
        });
    }
}

