/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.tests.impl;

import com.restlet.client.async.AsyncStreamWithResult;
import com.restlet.client.async.Deferred;
import com.restlet.client.async.Promise;
import com.restlet.client.async.PromiseHandler;
import com.restlet.client.async.Promises;
import com.restlet.client.async.impl.DeferredImpl;
import com.restlet.client.async.impl.WritableStreamWithResult;
import com.restlet.client.dao.EnvironmentsDao;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.function.BiConsumer;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.net.http.HttpClient;
import com.restlet.client.net.http.HttpClientResultTo;
import com.restlet.client.net.http.HttpStatusCodeRange;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.net.http.request.impl.EffectiveHttpRequestTo;
import com.restlet.client.script.ScriptService;
import com.restlet.client.script.impl.ExpressionRequestEvaluator;
import com.restlet.client.tests.ScenarioTo;
import com.restlet.client.tests.TestCaseResult;
import com.restlet.client.tests.TestResult;
import com.restlet.client.tests.TestRunner;
import com.restlet.client.tests.Testable;
import com.restlet.client.tests.asserts.AssertionEngine;
import com.restlet.client.tests.asserts.AssertionResultTo;
import com.restlet.client.tests.asserts.AssertionTo;
import com.restlet.client.tests.impl.HistoryCallback;
import com.restlet.client.tests.impl.TestCaseResultImpl;
import com.restlet.client.tests.impl.TestResultImpl;
import com.restlet.client.utils.EntityUtils;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TestRunnerImpl
implements TestRunner {
    private static final List<AssertionResultTo.State> assertionStatesThatAlterRequestState = Arrays.asList(AssertionResultTo.State.Error, AssertionResultTo.State.Failure, AssertionResultTo.State.Ok);
    private final HttpClient httpClient;
    private final ExpressionRequestEvaluator requestEvaluator;
    private final AssertionEngine assertionEngine;
    private final HistoryCallback callback;
    private final EnvironmentsDao environmentsDao;
    private RepositoryDao repositoryDao;
    private TestCaseResultStream stream;

    protected TestRunnerImpl(HttpClient httpClient, AssertionEngine assertionEngine, ScriptService scriptService, HistoryCallback callback, EnvironmentsDao environmentsDao, RepositoryDao repositoryDao, final Function<String, String> queryParameterEncoder) {
        this.httpClient = httpClient;
        this.assertionEngine = assertionEngine;
        this.callback = callback;
        this.environmentsDao = environmentsDao;
        this.repositoryDao = repositoryDao;
        this.requestEvaluator = new ExpressionRequestEvaluator(environmentsDao, scriptService){

            @Override
            protected String encodeQueryString(String query) {
                return (String)queryParameterEncoder.apply(query);
            }
        };
    }

    @Override
    public AsyncStreamWithResult<TestResult, TestCaseResult> run(Testable testable, Consumer<HttpClientResultTo> onRequestComplete) {
        if (testable instanceof HttpRequestTo) {
            return this.run((HttpRequestTo)testable, onRequestComplete);
        }
        return this.run((ScenarioTo)testable, onRequestComplete);
    }

    public AsyncStreamWithResult<TestResult, TestCaseResult> run(HttpRequestTo requestTo, Consumer<HttpClientResultTo> onRequestComplete) {
        final TestCaseResultImpl scenarioResult = new TestCaseResultImpl().setName(EntityUtils.generateDottedName(requestTo)).setFullName(EntityUtils.generateDottedName(requestTo)).setState(TestResult.State.InProgress);
        this.stream = new TestCaseResultStream(scenarioResult);
        final TestResult testResult = TestResultImpl.newTestResult(requestTo, TestResult.State.InProgress);
        scenarioResult.getTestResults().add(testResult);
        this.run(Promises.of(), testResult, onRequestComplete).doOnResolve(new Consumer<Void>(){

            @Override
            public void consume(Void whatever) {
                if (TestRunnerImpl.this.stream.isClosed()) {
                    return;
                }
                TestRunnerImpl.this.stream.accept(testResult);
                TestRunnerImpl.this.stream.closeIfStillOpened(scenarioResult);
            }
        });
        return this.stream;
    }

    public AsyncStreamWithResult<TestResult, TestCaseResult> run(ScenarioTo testScenario, final Consumer<HttpClientResultTo> onRequestComplete) {
        if (testScenario == null) {
            throw new IllegalArgumentException("The 'testCase' argument cannot be a null.");
        }
        final TestCaseResultImpl scenarioResult = new TestCaseResultImpl().setName(testScenario.getName()).setFullName(EntityUtils.generateDottedName(testScenario)).setState(TestResult.State.InProgress);
        this.stream = new TestCaseResultStream(scenarioResult);
        EntityUtils.getHttpRequests(this.repositoryDao, testScenario).doOnResolve(new Consumer<List<HttpRequestTo>>(){

            @Override
            public void consume(List<HttpRequestTo> httpRequests) {
                if (Objects.isNullOrEmpty(httpRequests)) {
                    scenarioResult.setState(TestResult.State.Ok);
                    TestRunnerImpl.this.stream.closeIfStillOpened(scenarioResult);
                    return;
                }
                for (HttpRequestTo request : httpRequests) {
                    scenarioResult.getTestResults().add(TestResultImpl.newTestResult(request, TestResult.State.InProgress));
                }
                Promise<Object> promise = Promises.of();
                for (final TestResult testResult : scenarioResult.getTestResults()) {
                    promise = TestRunnerImpl.this.run(promise, testResult, onRequestComplete).doOnResolve(new Consumer<Void>(){

                        @Override
                        public void consume(Void whatever) {
                            if (TestRunnerImpl.this.stream.isClosed()) {
                                return;
                            }
                            TestRunnerImpl.this.stream.accept(testResult);
                            if (TestResult.State.Failure == testResult.getState() || TestResult.State.Error == testResult.getState()) {
                                TestRunnerImpl.this.stream.closeIfStillOpened(scenarioResult);
                            }
                        }
                    });
                }
                promise.doOnResolve(new Consumer<Void>(){

                    @Override
                    public void consume(Void whatever) {
                        TestRunnerImpl.this.stream.closeIfStillOpened(scenarioResult);
                    }
                });
            }
        });
        return this.stream;
    }

    private Promise<Void> run(Promise<Void> promise, final TestResult result, final Consumer<HttpClientResultTo> onRequestComplete) {
        if (this.stream.isClosed()) {
            return Promises.of();
        }
        final DeferredImpl deferred = new DeferredImpl();
        promise.then(new PromiseHandler<Void>(){

            @Override
            public Object on(Void whatever) {
                if (TestRunnerImpl.this.stream.isClosed()) {
                    deferred.resolve();
                    return Promises.of();
                }
                return TestRunnerImpl.this.requestEvaluator.effective(result.getHttpRequest(), TestRunnerImpl.this.repositoryDao).then(new PromiseHandler<EffectiveHttpRequestTo>(){

                    @Override
                    public Object on(final EffectiveHttpRequestTo effectiveRequest) {
                        result.setDynamicRequest(effectiveRequest.isDynamic());
                        result.setLocalRequest(effectiveRequest.isLocal());
                        if (TestRunnerImpl.this.stream.isClosed()) {
                            deferred.resolve();
                            return Promises.of();
                        }
                        return TestRunnerImpl.this.httpClient.send(effectiveRequest.getHttpRequestTo()).then(new PromiseHandler<HttpClientResultTo>(){

                            @Override
                            public Object on(final HttpClientResultTo httpResult) {
                                onRequestComplete.consume(httpResult);
                                if (TestRunnerImpl.this.stream.isClosed()) {
                                    deferred.resolve();
                                    return Promises.of();
                                }
                                return TestRunnerImpl.this.callback.onRequestComplete(result.getHttpRequest().getId(), result.getHttpRequest(), httpResult).then(new PromiseHandler<Void>(){

                                    @Override
                                    public Object on(Void whatever) {
                                        if (httpResult != null) {
                                            result.setHttpResult(httpResult);
                                            if (TestRunnerImpl.this.atLeastOneEnabledAssertion(effectiveRequest.getHttpRequestTo().getAssertions())) {
                                                return TestRunnerImpl.this.evaluateAssertions(effectiveRequest.getHttpRequestTo(), httpResult, deferred, result);
                                            }
                                            result.setState(TestResult.State.Ok);
                                            if (httpResult.getResponse() != null && httpResult.getResponse().getStatus() != null && httpResult.getResponse().getStatus().getCode() != null) {
                                                boolean isValid = Sequence.of(HttpStatusCodeRange.SUCCESS_CODE_RANGES).some(new Predicate<HttpStatusCodeRange>(){

                                                    @Override
                                                    public boolean test(HttpStatusCodeRange acceptableStatusCode) {
                                                        return acceptableStatusCode.contains(httpResult.getResponse().getStatus().getCode());
                                                    }
                                                });
                                                if (HttpStatusCodeRange.ZERO.contains(httpResult.getResponse().getStatus().getCode())) {
                                                    result.setState(TestResult.State.Error);
                                                    result.setMessage("The server may be unavailable");
                                                } else if (!isValid) {
                                                    result.setState(TestResult.State.Failure);
                                                    result.setMessage("Response status code is " + httpResult.getResponse().getStatus().getCode());
                                                }
                                            }
                                        } else {
                                            result.setMessage("Unknown Error: null response");
                                            result.setState(TestResult.State.Error);
                                        }
                                        result.setHttpResult(httpResult);
                                        deferred.resolve();
                                        return null;
                                    }
                                }).onError(deferred.rejector());
                            }
                        }, new PromiseHandler<Throwable>(){

                            @Override
                            public Object on(Throwable error) {
                                if (TestRunnerImpl.this.stream.isClosed()) {
                                    return null;
                                }
                                result.setThrowable(error);
                                result.setMessage(error.getMessage());
                                result.setState(TestResult.State.Error);
                                deferred.resolve();
                                return null;
                            }
                        });
                    }
                }, new PromiseHandler<Throwable>(){

                    @Override
                    public Object on(Throwable error) {
                        result.setThrowable(error);
                        result.setMessage(error.getMessage());
                        result.setState(TestResult.State.Error);
                        deferred.resolve();
                        return null;
                    }
                });
            }
        });
        return deferred.promise();
    }

    private boolean atLeastOneEnabledAssertion(List<AssertionTo> assertions) {
        return Sequence.of(assertions).some(new Predicate<AssertionTo>(){

            @Override
            public boolean test(AssertionTo assertion) {
                return EntityUtils.isEnabled(assertion);
            }
        });
    }

    private Object evaluateAssertions(HttpRequestTo effective, HttpClientResultTo httpResult, final Deferred<Void> deferred, final TestResult result) {
        final ArrayList<AssertionResultTo> results = new ArrayList<AssertionResultTo>();
        for (AssertionTo assertion : effective.getAssertions()) {
            if (assertion == null) continue;
            results.add(new AssertionResultTo(assertion));
        }
        this.assertionEngine.evaluateAndCheck(results, httpResult, this.environmentsDao, this.repositoryDao).then(new PromiseHandler<Void>(){

            @Override
            public Object on(Void whatever) {
                if (TestRunnerImpl.this.stream.isClosed()) {
                    deferred.resolve();
                    return Promises.of();
                }
                for (AssertionResultTo ar : results) {
                    if (!assertionStatesThatAlterRequestState.contains((Object)ar.getState())) continue;
                    if (result.getState() == TestResult.State.Failure && ar.getState() == AssertionResultTo.State.Error) {
                        TestRunnerImpl.this.setStateAndMessageFromAssertion(result, ar);
                        continue;
                    }
                    if (result.getState() != TestResult.State.None && result.getState() != TestResult.State.InProgress && result.getState() != TestResult.State.Ok) continue;
                    TestRunnerImpl.this.setStateAndMessageFromAssertion(result, ar);
                }
                result.setAssertionResults(results);
                deferred.resolve();
                return null;
            }
        }).onError(deferred.rejector());
        return null;
    }

    private void setStateAndMessageFromAssertion(TestResult result, AssertionResultTo ar) {
        switch (ar.getState()) {
            case Error: {
                this.completeResultMessage(result, ar, AssertionResultTo.State.Error);
                result.setState(TestResult.State.Error);
                break;
            }
            case Failure: {
                this.completeResultMessage(result, ar, AssertionResultTo.State.Failure);
                result.setState(TestResult.State.Failure);
                break;
            }
            case Ok: {
                result.setState(TestResult.State.Ok);
            }
        }
    }

    private void completeResultMessage(TestResult result, AssertionResultTo ar, AssertionResultTo.State state) {
        for (AssertionResultTo.AssertionResultMessage message : ar.getMessages(state)) {
            result.setMessage(message.message);
        }
    }

    @Override
    public Promise<Void> cancel() {
        if (this.stream != null) {
            this.stream.cancel();
        }
        if (this.httpClient.isPending()) {
            this.httpClient.cancel();
        }
        return Promises.of();
    }

    @Override
    public TestRunner setRepositoryDao(RepositoryDao repositoryDao) {
        this.repositoryDao = repositoryDao;
        return this;
    }

    private static class TestCaseResultStream
    extends WritableStreamWithResult<TestResult, TestCaseResult> {
        final TestCaseResult testCaseResult;

        TestCaseResultStream(TestCaseResult testCaseResult) {
            this.testCaseResult = testCaseResult;
        }

        void cancel() {
            this.computeFinalScenarioState(this.testCaseResult, TestResult.State.Aborted, TestResult.State.Aborted);
            super.closeIfStillOpened(this.testCaseResult);
        }

        @Override
        public AsyncStreamWithResult<TestResult, TestCaseResult> closeIfStillOpened(TestCaseResult result) {
            this.computeFinalScenarioState(result);
            return super.closeIfStillOpened(result);
        }

        @Override
        public void closeIfStillOpened(Throwable throwable) {
            this.computeFinalScenarioState(this.testCaseResult);
            super.closeIfStillOpened(throwable);
        }

        private void computeFinalScenarioState(TestCaseResult result) {
            this.computeFinalScenarioState(result, TestResult.State.Ok, TestResult.State.Skipped);
        }

        private void computeFinalScenarioState(TestCaseResult result, TestResult.State scenarioState, final TestResult.State requestState) {
            Map<TestResult.State, List<TestResult>> resultsByState = Sequence.of(result.getTestResults()).groupBy(new Function<TestResult, TestResult.State>(){

                @Override
                public TestResult.State apply(TestResult testResult) {
                    return testResult.getState();
                }
            });
            Sequence.of((Iterable)resultsByState.get((Object)TestResult.State.InProgress)).each(new BiConsumer<TestResult, Integer>(){

                @Override
                public void consume(TestResult testResult, Integer index) {
                    testResult.setState(requestState);
                    TestCaseResultStream.this.accept(testResult);
                }
            });
            result.setState(scenarioState);
            if (resultsByState.containsKey((Object)TestResult.State.Error)) {
                result.setState(TestResult.State.Error);
            } else if (resultsByState.containsKey((Object)TestResult.State.Failure)) {
                result.setState(TestResult.State.Failure);
            }
        }
    }
}

