/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.tests.asserts.impl;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.async.impl.DeferredImpl;
import com.restlet.client.html.HtmlKit;
import com.restlet.client.net.http.HttpDate;
import com.restlet.client.net.http.response.HttpResponseTo;
import com.restlet.client.platform.blob.BlobReader;
import com.restlet.client.platform.xml.XPathResult;
import com.restlet.client.platform.xml.XmlEngine;
import com.restlet.client.platform.xml.XmlNode;
import com.restlet.client.tests.asserts.AssertionResultTo;
import com.restlet.client.tests.asserts.ResponseBodyAssertionEngine;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.StringUtils;
import java.util.Collection;
import java.util.Date;

public class XmlAssertionEngineImpl
implements ResponseBodyAssertionEngine {
    private final XmlEngine xmlEngine;
    private final HttpDate httpDate;
    private final BlobReader blobReader;
    private final HtmlKit htmlKit;

    public XmlAssertionEngineImpl(XmlEngine xmlEngine, HttpDate httpDate, BlobReader blobReader, HtmlKit htmlKit) {
        this.xmlEngine = xmlEngine;
        this.httpDate = httpDate;
        this.blobReader = blobReader;
        this.htmlKit = htmlKit;
    }

    @Override
    public Promise<Void> checkBody(final AssertionResultTo assertion, HttpResponseTo response) {
        if (response == null) {
            return Promises.of();
        }
        if (StringUtils.isBlank(assertion.getPath())) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> is required.");
            return Promises.of();
        }
        if (response.getBody() == null || response.getBody().getBlob() == null || response.getBody().getBlob().size() <= 0) {
            assertion.setState(AssertionResultTo.State.Failure);
            assertion.addFailureMessage("Response body does not exist.");
            return Promises.of();
        }
        final DeferredImpl deferred = new DeferredImpl();
        this.blobReader.readAsText(response.getBody().getBlob(), new BlobReader.Handler<String>(){

            @Override
            public void onLoaded(String responseBodyAsText) {
                if (!StringUtils.isBlank(responseBodyAsText)) {
                    assertion.setActualValue(responseBodyAsText);
                    XmlAssertionEngineImpl.this.matchXml(responseBodyAsText, assertion);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response body is not XML.");
                }
                deferred.resolve();
            }

            @Override
            public void onError(Object o) {
                deferred.resolve();
            }
        });
        return deferred.promise();
    }

    private boolean matchXml(String xml, AssertionResultTo assertion) {
        XPathResult xPathResult;
        XmlNode node;
        String stringPath = StringUtils.firstNotBlank(assertion.getEvaluatedPath(), assertion.getPath()).orElse(null);
        if (StringUtils.isBlank(stringPath)) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> is required.");
            return false;
        }
        try {
            node = Maybe.of(this.xmlEngine.fromXml(xml)).get();
        }
        catch (Throwable e) {
            assertion.setState(AssertionResultTo.State.Failure);
            assertion.addFailureMessage("Response body is not valid XML.");
            return false;
        }
        try {
            xPathResult = Maybe.of(this.xmlEngine.xpath(node, stringPath)).get();
        }
        catch (Throwable e) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("'" + stringPath + "' is not valid <a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a>");
            return false;
        }
        switch (assertion.getComparison()) {
            case Exists: {
                if (!xPathResult.isEmpty()) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case DoesNotExist: {
                if (xPathResult.isEmpty()) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target exists, &lt;" + this.htmlEscape(xPathResult, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
        }
        if (xPathResult.getResultType() == null) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("Unknown XPath result type.");
            return false;
        }
        String stringValue = StringUtils.firstNotBlank(assertion.getEvaluatedValue(), assertion.getValue()).orElse(null);
        if (xPathResult.getResultType() == XPathResult.XPathResultType.String || xPathResult.getResultType() == XPathResult.XPathResultType.Boolean || xPathResult.getResultType() == XPathResult.XPathResultType.Number) {
            Object expectedValue = stringValue;
            Object sourceValue = null;
            switch (xPathResult.getResultType()) {
                case String: {
                    sourceValue = xPathResult.getStringValue();
                    break;
                }
                case Number: {
                    sourceValue = xPathResult.getNumberValue();
                    try {
                        expectedValue = Double.valueOf(stringValue);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case Boolean: {
                    sourceValue = xPathResult.getBooleanValue();
                    try {
                        expectedValue = Boolean.valueOf(stringValue);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            Boolean validated = this.validate(assertion, sourceValue, expectedValue);
            if (validated != null) {
                return validated;
            }
        }
        Boolean passed = null;
        Collection<XmlNode> sourceNodes = xPathResult.getMatchingNodes();
        if (sourceNodes != null) {
            for (XmlNode n : sourceNodes) {
                Boolean p = this.validate(assertion, n.toString().trim().replaceAll(">\\s*", ">").replaceAll("\\s<", ""), stringValue);
                if (p != null) {
                    passed = passed == null ? p : Boolean.valueOf(passed != false && p != false);
                }
                if (passed == null || passed.booleanValue()) continue;
                return false;
            }
        }
        if (passed == null) {
            assertion.setState(AssertionResultTo.State.Failure);
            assertion.addFailureMessage("Nothing found for the given XPath. [" + stringPath + "]");
        }
        return false;
    }

    public Boolean validate(AssertionResultTo assertion, Object sourceValue, Object expectedValue) {
        switch (assertion.getComparison()) {
            case Exists: {
                if (sourceValue != null) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case DoesNotExist: {
                if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target exists, &lt;" + this.htmlEscape(sourceValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Equals: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (this.equals(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Expected sourceValue: &lt;" + this.htmlEscape(expectedValue, "null") + "&gt; but was: &lt;" + this.htmlEscape(sourceValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case DoesNotEqual: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (!this.equals(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value: &lt;" + this.htmlEscape(sourceValue, "null") + "&gt; is the same.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Contains: {
                if (sourceValue != null && expectedValue != null && this.contains(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; does not contain &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case DoesNotContain: {
                if (sourceValue != null && expectedValue != null && !this.contains(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    return true;
                }
                if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                } else if (expectedValue != null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; contains &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Less: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) < 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not less than &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case LessOrEqual: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) <= 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not less or equal to &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Greater: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) > 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not greater than &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case GreateOrEqual: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) >= 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"https://www.w3.org/TR/xpath/\" target=\"_blank\">XPath 1.0</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not greater or equal to &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
        }
        return null;
    }

    private void warnUserTypesDiffer(AssertionResultTo assertion, Object value, Object expected) {
        if (expected == null || value == null) {
            return;
        }
        if (!this.haveSameType(value, expected)) {
            assertion.addWarningMessage("Assertion compares values as strings (<a href=\"https://en.wikipedia.org/wiki/Lexicographical_order\" target=\"_blank\">lexicographically</a>) since &lt;" + this.htmlEscape(value) + "&gt; and &lt;" + this.htmlEscape(expected, "null") + "&gt; have different types (&lt;" + this.htmlEscape(value) + "&gt; has type \"" + this.getType(value) + "\" and &lt;" + this.htmlEscape(expected, "null") + "&gt; has type \"" + this.getType(expected) + "\")");
        }
    }

    private boolean haveSameType(Object v1, Object v2) {
        return this.areBooleanValues(v1, v2) || this.areDoubleValues(v1, v2) || this.areStringValues(v1, v2);
    }

    private String getType(Object value) {
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Double) {
            return "number";
        }
        if (value instanceof String) {
            return "string";
        }
        return "object";
    }

    private boolean equals(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return false;
        }
        if (this.areBooleanValues(v1, v2)) {
            return ((Boolean)v1).booleanValue() == ((Boolean)v2).booleanValue();
        }
        if (this.areDoubleValues(v1, v2)) {
            return ((Double)v1).doubleValue() == ((Double)v2).doubleValue();
        }
        if (this.areStringValues(v1, v2)) {
            String s1 = v1.toString();
            String s2 = v2.toString();
            Date d1 = this.httpDate.valueOf(s1);
            Date d2 = this.httpDate.valueOf(s2);
            if (d1 != null && d2 != null) {
                return d1.equals(d2);
            }
            return s1.equalsIgnoreCase(s2);
        }
        String s1 = v1.toString();
        String s2 = v2.toString();
        return s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public int compare(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (this.areBooleanValues(v1, v2)) {
            if (((Boolean)v1).booleanValue() && ((Boolean)v2).booleanValue() || !((Boolean)v1).booleanValue() && !((Boolean)v2).booleanValue()) {
                return 0;
            }
            if (((Boolean)v1).booleanValue()) {
                return 1;
            }
            return -1;
        }
        if (this.areDoubleValues(v1, v2)) {
            return ((Double)v1).compareTo((Double)v2);
        }
        if (this.areStringValues(v1, v2)) {
            Comparable<Double> d2;
            Comparable<Double> d12;
            try {
                Long l1 = Long.valueOf(v1.toString());
                Long l2 = Long.valueOf(v2.toString());
                if (l1 != null && l2 != null) {
                    return l1.compareTo(l2);
                }
            }
            catch (Exception l1) {
                // empty catch block
            }
            try {
                d12 = Double.valueOf(v1.toString());
                d2 = Double.valueOf(v2.toString());
                if (d12 != null && d2 != null) {
                    return ((Double)d12).compareTo((Double)d2);
                }
            }
            catch (Exception d12) {
                // empty catch block
            }
            d12 = this.httpDate.valueOf(v1.toString());
            d2 = this.httpDate.valueOf(v2.toString());
            if (d12 != null && d2 != null) {
                return ((Date)d12).compareTo((Date)d2);
            }
            return v1.toString().compareToIgnoreCase(v2.toString());
        }
        String s1 = v1.toString();
        String s2 = v2.toString();
        return s1 != null && s2 != null ? s1.compareToIgnoreCase(s2) : (s1 == null ? -1 : 1);
    }

    private boolean areBooleanValues(Object v1, Object v2) {
        return v1 instanceof Boolean && v2 instanceof Boolean;
    }

    private boolean areDoubleValues(Object v1, Object v2) {
        return v1 instanceof Double && v2 instanceof Double;
    }

    private boolean areStringValues(Object v1, Object v2) {
        return v1 instanceof String && v2 instanceof String;
    }

    private boolean contains(Object o1, Object o2) {
        if (o1 != null && o2 != null) {
            String s2;
            String s1 = o1 instanceof String ? (String)o1 : o1.toString();
            String string = s2 = o2 instanceof String ? (String)o2 : o2.toString();
            if (s1 != null && s2 != null) {
                return s1.toLowerCase().contains(s2.toLowerCase());
            }
        }
        return false;
    }

    private String htmlEscape(Object value, String defaultValue) {
        return value == null ? defaultValue : this.htmlKit.escape(value.toString());
    }

    private String htmlEscape(Object value) {
        return this.htmlEscape(value, null);
    }
}

