/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.tests.asserts.impl;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.async.impl.DeferredImpl;
import com.restlet.client.html.HtmlKit;
import com.restlet.client.net.http.HttpDate;
import com.restlet.client.net.http.response.HttpResponseTo;
import com.restlet.client.platform.blob.BlobReader;
import com.restlet.client.platform.json.JsonArray;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonException;
import com.restlet.client.platform.json.JsonObject;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.tests.asserts.AssertionResultTo;
import com.restlet.client.tests.asserts.ResponseBodyAssertionEngine;
import com.restlet.client.utils.StringUtils;
import java.util.Date;
import java.util.Objects;

public class JsonAssertionEngineImpl
implements ResponseBodyAssertionEngine {
    private final JsonEngine jsonEngine;
    private final HttpDate httpDate;
    private final BlobReader blobReader;
    private final HtmlKit htmlKit;

    public JsonAssertionEngineImpl(JsonEngine jsonEngine, HttpDate httpDate, BlobReader blobReader, HtmlKit htmlKit) {
        this.jsonEngine = jsonEngine;
        this.httpDate = httpDate;
        this.blobReader = blobReader;
        this.htmlKit = htmlKit;
    }

    private boolean matchJson(String json, AssertionResultTo assertion) {
        String stringPath = StringUtils.firstNotBlank(assertion.getEvaluatedPath(), assertion.getPath()).orElse(null);
        if (StringUtils.isBlank(stringPath)) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> is required.");
            return false;
        }
        if (!stringPath.startsWith("$")) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("&lt;" + stringPath + "&gt; is not valid <a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a>.");
            return false;
        }
        try {
            Boolean validated;
            JsonValue expectedValue;
            JsonValue root = this.jsonEngine.fromJson(json);
            if (root == null) {
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body is not valid Json.");
                return false;
            }
            if (root.isObject() == null && root.isArray() == null) {
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body is not Json Object.");
                return false;
            }
            JsonValue sourceValue = root.isObject() != null ? this.extract(root.isObject(), stringPath, assertion) : this.extract(root.isArray(), stringPath, assertion);
            String stringValue = StringUtils.firstNotBlank(assertion.getEvaluatedValue(), assertion.getValue()).orElse(null);
            if (!StringUtils.isBlank(stringValue)) {
                try {
                    expectedValue = this.jsonEngine.fromJson(stringValue);
                }
                catch (JsonException e) {
                    expectedValue = this.jsonEngine.newJsonString(stringValue);
                }
            } else {
                expectedValue = this.jsonEngine.newJsonString("");
            }
            if (sourceValue != null && sourceValue.isNull() != null) {
                sourceValue = null;
            }
            if (expectedValue != null && expectedValue.isNull() != null) {
                expectedValue = null;
            }
            return (validated = this.validate(assertion, sourceValue, expectedValue)) != null ? validated : false;
        }
        catch (Throwable e) {
            assertion.setState(AssertionResultTo.State.Failure);
            assertion.addFailureMessage("Response body is not valid JSON. [" + this.htmlKit.escape(e.getMessage()) + "]");
            return false;
        }
    }

    public Boolean validate(AssertionResultTo assertion, JsonValue sourceValue, JsonValue expectedValue) {
        switch (assertion.getComparison()) {
            case Equals: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (this.equals(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Expected sourceValue: &lt;" + this.htmlEscape(expectedValue, "null") + "&gt; but was: &lt;" + this.htmlEscape(sourceValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case DoesNotEqual: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (!this.equals(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value: &lt;" + this.htmlEscape(sourceValue, "null") + "&gt; is the same.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Exists: {
                if (sourceValue != null) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target does not exist or is a null.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case DoesNotExist: {
                if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target exists, &lt;" + this.htmlEscape(sourceValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Contains: {
                if (sourceValue != null && expectedValue != null && this.contains(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; does not contain &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case DoesNotContain: {
                if (sourceValue != null && expectedValue != null && !this.contains(sourceValue, expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target does not exist or is a null.");
                } else if (expectedValue != null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; contains &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Less: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) < 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not less than &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case LessOrEqual: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) <= 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not less or equal to &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case Greater: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) > 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not greater than &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
            case GreateOrEqual: {
                this.warnUserTypesDiffer(assertion, sourceValue, expectedValue);
                if (sourceValue != null && expectedValue != null && this.compare(sourceValue, expectedValue) >= 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                } else if (sourceValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> target does not exist or is a null.");
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Value &lt;" + this.htmlEscape(sourceValue) + "&gt; is not greater or equal to &lt;" + this.htmlEscape(expectedValue, "null") + "&gt;.");
                }
                return AssertionResultTo.State.Ok == assertion.getState();
            }
        }
        return null;
    }

    private String htmlEscape(JsonValue value, String defaultValue) {
        return value == null ? defaultValue : this.htmlKit.escape(value.toString());
    }

    private String htmlEscape(JsonValue value) {
        return this.htmlEscape(value, null);
    }

    private JsonValue extract(JsonArray root, String selector, AssertionResultTo assertion) {
        try {
            JsonValue val = this.jsonEngine.jsonPath(root, selector);
            if (val == null) {
                return root;
            }
            return val;
        }
        catch (JsonException e) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> cannot be evaluated.");
            return null;
        }
    }

    private JsonValue extract(JsonObject root, String selector, AssertionResultTo assertion) {
        try {
            return this.jsonEngine.jsonPath(root, selector);
        }
        catch (JsonException e) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> cannot be evaluated.");
            return null;
        }
    }

    private boolean haveSameType(JsonValue v1, JsonValue v2) {
        return this.areNullValues(v1, v2) || this.areBooleanValues(v1, v2) || this.areNumberValues(v1, v2) || this.areArrayValues(v1, v2) || this.areObjectValues(v1, v2) || this.areStringValues(v1, v2);
    }

    private String getType(JsonValue value) {
        if (value.isNull() != null) {
            return "null";
        }
        if (value.isArray() != null) {
            return "array";
        }
        if (value.isBoolean() != null) {
            return "boolean";
        }
        if (value.isNumber() != null) {
            return "number";
        }
        if (value.isString() != null) {
            return "string";
        }
        if (value.isObject() != null) {
            return "object";
        }
        return null;
    }

    private void warnUserTypesDiffer(AssertionResultTo assertion, JsonValue value, JsonValue expected) {
        if (expected == null || value == null) {
            return;
        }
        if (!this.haveSameType(value, expected)) {
            assertion.addWarningMessage("Assertion compares values as strings (<a href=\"https://en.wikipedia.org/wiki/Lexicographical_order\" target=\"_blank\">lexicographically</a>) since &lt;" + this.htmlEscape(value) + "&gt; and &lt;" + this.htmlEscape(expected, "null") + "&gt; have different types (&lt;" + this.htmlEscape(value) + "&gt; has type \"" + this.getType(value) + "\" and &lt;" + this.htmlEscape(expected, "null") + "&gt; has type \"" + this.getType(expected) + "\")");
        }
    }

    public int compare(JsonValue v1, JsonValue v2) {
        String s2;
        boolean equals;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (this.areNullValues(v1, v2)) {
            return 0;
        }
        if (this.areBooleanValues(v1, v2)) {
            if (v1.isBoolean().booleanValue() == v2.isBoolean().booleanValue()) {
                return 0;
            }
            if (v1.isBoolean().booleanValue()) {
                return 1;
            }
            return -1;
        }
        if (this.areNumberValues(v1, v2)) {
            if (v1.isNumber().doubleValue() == v2.isNumber().doubleValue()) {
                return 0;
            }
            if (v1.isNumber().doubleValue() > v2.isNumber().doubleValue()) {
                return 1;
            }
            return -1;
        }
        if (this.areArrayValues(v1, v2)) {
            if (v1.isArray().size() < v2.isArray().size()) {
                return -1;
            }
            if (v1.isArray().size() > v2.isArray().size()) {
                return 1;
            }
            equals = true;
            for (int i = 0; i < v1.isArray().size() && (equals = this.equals(v1.isArray().get(i), v2.isArray().get(i))); ++i) {
            }
            if (equals) {
                return 0;
            }
        }
        if (this.areObjectValues(v1, v2)) {
            if (v1.isObject().keySet().size() < v2.isObject().keySet().size()) {
                return -1;
            }
            if (v1.isObject().keySet().size() > v2.isObject().keySet().size()) {
                return 1;
            }
            equals = true;
            for (String key : v1.isObject().keySet()) {
                equals = v2.isObject().containsKey(key) && this.equals(v1.isObject().get(key), v2.isObject().get(key));
                if (equals) continue;
                break;
            }
            if (equals) {
                return 0;
            }
        }
        if (this.areStringValues(v1, v2)) {
            Comparable<Double> d2;
            Comparable<Double> d12;
            String s1 = v1.isString().stringValue();
            String s22 = v2.isString().stringValue();
            try {
                Long l1 = Long.valueOf(s1);
                Long l2 = Long.valueOf(s22);
                if (l1 != null && l2 != null) {
                    return l1.compareTo(l2);
                }
            }
            catch (Exception l1) {
                // empty catch block
            }
            try {
                d12 = Double.valueOf(s1);
                d2 = Double.valueOf(s22);
                if (d12 != null && d2 != null) {
                    return ((Double)d12).compareTo((Double)d2);
                }
            }
            catch (Exception d12) {
                // empty catch block
            }
            d12 = this.httpDate.valueOf(s1);
            d2 = this.httpDate.valueOf(s22);
            if (d12 != null && d2 != null) {
                return ((Date)d12).compareTo((Date)d2);
            }
            return s1.compareToIgnoreCase(s22);
        }
        String s1 = v1.isString() != null ? v1.isString().stringValue() : v1.toString();
        String string = s2 = v2.isString() != null ? v2.isString().stringValue() : v2.toString();
        return s1 != null && s2 != null ? s1.compareToIgnoreCase(s2) : (s1 == null ? -1 : 1);
    }

    private boolean areStringValues(JsonValue v1, JsonValue v2) {
        return v1.isString() != null && v2.isString() != null;
    }

    private boolean areObjectValues(JsonValue v1, JsonValue v2) {
        return v1.isObject() != null && v2.isObject() != null;
    }

    private boolean areArrayValues(JsonValue v1, JsonValue v2) {
        return v1.isArray() != null && v2.isArray() != null;
    }

    private boolean areNumberValues(JsonValue v1, JsonValue v2) {
        return v1.isNumber() != null && v2.isNumber() != null;
    }

    private boolean areBooleanValues(JsonValue v1, JsonValue v2) {
        return v1.isBoolean() != null && v2.isBoolean() != null;
    }

    private boolean areNullValues(JsonValue v1, JsonValue v2) {
        return v1.isNull() != null && v2.isNull() != null;
    }

    private boolean equals(JsonValue sourceValue, JsonValue expectedValue) {
        if (sourceValue != null && expectedValue != null) {
            if (this.areNullValues(sourceValue = this.unwrapFirstArrayElementIfTypeMismatch(sourceValue, expectedValue), expectedValue)) {
                return true;
            }
            if (this.areBooleanValues(sourceValue, expectedValue)) {
                return sourceValue.isBoolean().booleanValue() == expectedValue.isBoolean().booleanValue();
            }
            if (this.areNumberValues(sourceValue, expectedValue)) {
                return sourceValue.isNumber().doubleValue() == expectedValue.isNumber().doubleValue();
            }
            if (this.areArrayValues(sourceValue, expectedValue)) {
                if (Objects.equals(sourceValue.isArray().size(), expectedValue.isArray().size())) {
                    for (int i = 0; i < sourceValue.isArray().size(); ++i) {
                        if (this.equals(sourceValue.isArray().get(i), expectedValue.isArray().get(i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (this.areObjectValues(sourceValue, expectedValue)) {
                if (sourceValue.isObject().keySet().size() == expectedValue.isObject().keySet().size()) {
                    for (String key : sourceValue.isObject().keySet()) {
                        if (expectedValue.isObject().containsKey(key) && this.equals(sourceValue.isObject().get(key), expectedValue.isObject().get(key))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (this.areStringValues(sourceValue, expectedValue)) {
                String s1 = sourceValue.isString().stringValue();
                String s2 = expectedValue.isString().stringValue();
                Date d1 = this.httpDate.valueOf(s1);
                Date d2 = this.httpDate.valueOf(s2);
                if (d1 != null && d2 != null) {
                    return d1.equals(d2);
                }
                return s1.equalsIgnoreCase(s2);
            }
            String s1 = sourceValue.isString() != null ? sourceValue.isString().stringValue() : sourceValue.toString();
            String s2 = expectedValue.isString() != null ? expectedValue.isString().stringValue() : expectedValue.toString();
            return s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
        }
        return sourceValue == null && expectedValue == null;
    }

    private JsonValue unwrapFirstArrayElementIfTypeMismatch(JsonValue sourceValue, JsonValue expectedValue) {
        if (sourceValue.isArray() != null && sourceValue.isArray().size() == 1 && expectedValue.isArray() == null) {
            sourceValue = sourceValue.isArray().get(0);
        }
        return sourceValue;
    }

    private boolean contains(JsonValue v1, JsonValue v2) {
        if (v1 != null && v2 != null) {
            String s2;
            String s1 = v1.isString() != null ? v1.isString().stringValue() : v1.toString();
            String string = s2 = v2.isString() != null ? v2.isString().stringValue() : v2.toString();
            if (s1 != null && s2 != null) {
                return s1.toLowerCase().contains(s2.toLowerCase());
            }
        }
        return false;
    }

    @Override
    public Promise<Void> checkBody(final AssertionResultTo assertion, HttpResponseTo response) {
        if (response == null) {
            return Promises.of();
        }
        if (StringUtils.isBlank(assertion.getPath())) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("<a href=\"http://goessner.net/articles/JsonPath/\" target=\"_blank\">JSON Path</a> is required.");
            return Promises.of();
        }
        if (response.getBody() == null || response.getBody().getBlob() == null || response.getBody().getBlob().size() <= 0) {
            assertion.setState(AssertionResultTo.State.Failure);
            assertion.addFailureMessage("Response body does not exist.");
            return Promises.of();
        }
        final DeferredImpl deferred = new DeferredImpl();
        this.blobReader.readAsText(response.getBody().getBlob(), new BlobReader.Handler<String>(){

            @Override
            public void onLoaded(String responseBodyAsText) {
                if (!StringUtils.isBlank(responseBodyAsText)) {
                    assertion.setActualValue(responseBodyAsText);
                    JsonAssertionEngineImpl.this.matchJson(responseBodyAsText, assertion);
                } else {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response body is not JSON.");
                }
                deferred.resolve();
            }

            @Override
            public void onError(Object o) {
                deferred.resolve();
            }
        });
        return deferred.promise();
    }
}

