/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.tests.asserts;

import com.restlet.client.function.Function;
import com.restlet.client.tests.TestResult;
import com.restlet.client.tests.asserts.AssertionTo;
import com.restlet.client.utils.Iterables;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

public class AssertionResultTo
implements AssertionTo {
    public static final String ASSERTION_PATH_STATUS_MESSAGE = "message";
    public static final String ASSERTION_PATH_STATUS_CODE = "code";
    public static final String ASSERTION_PATH_RESPONSE_BODY_CONTENT = "content";
    public static final String ASSERTION_PATH_RESPONSE_BODY_LENGTH = "length";
    public static final String ASSERTION_PATH_RESPONSE_LATENCY = "latency";
    private State state;
    private final AssertionTo assertion;
    private final Collection<AssertionResultMessage> messages = new LinkedHashSet<AssertionResultMessage>();
    private String evaluatedPath;
    private String evaluatedValue;
    private String actualValue;

    public AssertionResultTo(AssertionTo assertion) {
        this.assertion = assertion;
    }

    @Override
    public Boolean isEnabled() {
        return this.assertion.isEnabled();
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.assertion.setEnabled(enabled);
    }

    @Override
    public AssertionTo.Subject getSubject() {
        return this.assertion.getSubject();
    }

    @Override
    public void setSubject(AssertionTo.Subject subject) {
        this.assertion.setSubject(subject);
    }

    @Override
    public String getPath() {
        return this.assertion.getPath();
    }

    @Override
    public void setPath(String path) {
        this.assertion.setPath(path);
    }

    @Override
    public AssertionTo.Comparison getComparison() {
        return this.assertion.getComparison();
    }

    @Override
    public void setComparison(AssertionTo.Comparison comparison) {
        this.assertion.setComparison(comparison);
    }

    @Override
    public String getValue() {
        return this.assertion.getValue();
    }

    @Override
    public void setValue(String value) {
        this.assertion.setValue(value);
    }

    public final AssertionTo getAssertion() {
        return this.assertion;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Collection<AssertionResultMessage> getMessages() {
        return this.messages;
    }

    public Collection<AssertionResultMessage> getMessages(State state) {
        LinkedHashSet<AssertionResultMessage> messagesByState = new LinkedHashSet<AssertionResultMessage>();
        for (AssertionResultMessage message : this.messages) {
            if (message.state != state) continue;
            messagesByState.add(message);
        }
        return messagesByState;
    }

    public void addFailureMessage(String message) {
        this.messages.add(new AssertionResultMessage(State.Failure, message));
    }

    public void addErrorMessage(String message) {
        this.messages.add(new AssertionResultMessage(State.Error, message));
    }

    public void addWarningMessage(String message) {
        this.messages.add(new AssertionResultMessage(State.Warning, message));
    }

    public String getEvaluatedPath() {
        return this.evaluatedPath;
    }

    public void setEvaluatedPath(String evaluatedPath) {
        this.evaluatedPath = evaluatedPath;
    }

    public String getEvaluatedValue() {
        return this.evaluatedValue;
    }

    public void setEvaluatedValue(String evaluatedValue) {
        this.evaluatedValue = evaluatedValue;
    }

    public String getActualValue() {
        return this.actualValue;
    }

    public AssertionResultTo setActualValue(String actualValue) {
        this.actualValue = actualValue;
        return this;
    }

    public static State getPrimaryState(List<AssertionResultTo> assertionResults, State defaultState) {
        List<State> orderedStates = Sequence.of(assertionResults).omitNulls().map(new Function<AssertionResultTo, State>(){

            @Override
            public State apply(AssertionResultTo assertionResult) {
                return assertionResult.getState();
            }
        }).omitNulls().toList();
        Collections.sort(orderedStates, State.getStateComparator());
        return Iterables.getFirst(orderedStates).orElse(defaultState);
    }

    public static class AssertionResultMessage {
        public State state;
        public String message;

        AssertionResultMessage(State state, String message) {
            this.state = state;
            this.message = message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssertionResultMessage that = (AssertionResultMessage)o;
            return this.state == that.state && Objects.equals(this.message, that.message);
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            return result;
        }
    }

    public static enum State {
        Ok(TestResult.State.Ok),
        Failure(TestResult.State.Failure),
        Error(TestResult.State.Failure),
        Warning(TestResult.State.Ok);

        private static final List<State> ORDERED_STATES;
        public final TestResult.State testResultState;

        private State(TestResult.State testResultState) {
            this.testResultState = testResultState;
        }

        public static Comparator<State> getStateComparator() {
            return new Comparator<State>(){

                @Override
                public int compare(State state1, State state2) {
                    if (!ORDERED_STATES.contains((Object)state1)) {
                        throw new RuntimeException("State " + (Object)((Object)state1) + " is not in the ordered list of states.");
                    }
                    if (!ORDERED_STATES.contains((Object)state2)) {
                        throw new RuntimeException("State " + (Object)((Object)state2) + " is not in the ordered list of states.");
                    }
                    return Integer.compare(ORDERED_STATES.indexOf((Object)state1), ORDERED_STATES.indexOf((Object)state2));
                }
            };
        }

        static {
            ORDERED_STATES = Arrays.asList(Error, Failure, Warning, Ok);
        }
    }
}

