/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.runtime.impl;

import com.restlet.client.net.MessageHeaderTo;
import com.restlet.client.platform.json.JsonArray;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonObject;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.utils.FunctionalUtils;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.StringUtils;
import java.util.List;

public class ResponseJSONReference {
    private final JsonObject root;
    private final JsonEngine jsonEngine;

    public ResponseJSONReference(JsonObject root, JsonEngine jsonEngine) {
        this.root = root;
        this.jsonEngine = jsonEngine;
    }

    public void setHeaders(List<MessageHeaderTo> headers) {
        if (!Objects.isNullOrEmpty(headers)) {
            JsonObject refHeaders = this.jsonEngine.newJsonObject();
            for (MessageHeaderTo reqHeader : headers) {
                if (reqHeader == null || StringUtils.isBlank(reqHeader.getName()) || reqHeader.getValue() == null) continue;
                JsonValue refHeader = refHeaders.get(reqHeader.getName().toLowerCase());
                if (refHeader == null) {
                    refHeaders.put(reqHeader.getName().toLowerCase(), this.jsonEngine.newJsonString(reqHeader.getValue()));
                    continue;
                }
                if (refHeader.isArray() != null) {
                    refHeader.isArray().set(refHeader.isArray().size(), this.jsonEngine.newJsonString(reqHeader.getValue()));
                    continue;
                }
                if (refHeader.isString() == null) continue;
                JsonArray refHeadersArray = this.jsonEngine.newJsonArray();
                refHeadersArray.set(0, refHeader);
                refHeadersArray.set(1, this.jsonEngine.newJsonString(reqHeader.getValue()));
                refHeaders.put(reqHeader.getName().toLowerCase(), refHeadersArray);
            }
            this.root.put("headers", refHeaders);
        } else {
            this.root.put("headers", null);
        }
    }

    JsonValue asJSON() {
        return this.root;
    }

    public void setStatus(Integer statusCode, String statusMessage) {
        if (statusCode != null || !StringUtils.isBlank(statusMessage)) {
            JsonObject status = this.jsonEngine.newJsonObject();
            if (statusCode != null) {
                status.put("code", this.jsonEngine.newJsonNumber(statusCode.intValue()));
            }
            if (!StringUtils.isBlank(statusMessage)) {
                status.put("message", this.jsonEngine.newJsonString(statusMessage));
            }
            this.root.put("status", status);
        }
    }

    public void setBody(String text) {
        if (!StringUtils.isBlank(text)) {
            try {
                JsonValue json = this.jsonEngine.fromJson(text);
                this.root.put("body", FunctionalUtils.ifNotNull(json, FunctionalUtils.identity(), this.jsonEngine.newJsonString(text)));
            }
            catch (Throwable e) {
                this.root.put("body", this.jsonEngine.newJsonString(text));
            }
        }
    }
}

