/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.method;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptStringValue;
import java.util.List;

public class StringMethod
implements ScriptMethod {
    final JsonEngine jsonEngine;

    public StringMethod(JsonEngine jsonEngine) {
        this.jsonEngine = jsonEngine;
    }

    @Override
    public String getName() {
        return "string";
    }

    @Override
    public Promise<ScriptValue> execute(ScriptValue value, List<ScriptValue> args) {
        if (value == null) {
            return Promises.of();
        }
        if (args != null && !args.isEmpty() && "'".equals(args.get(0).toString().trim())) {
            return Promises.of(new ScriptStringValue("'" + this.escape(value.toString(), '\'') + "'", this.jsonEngine));
        }
        return Promises.of(new ScriptStringValue("\"" + this.escape(value.toString(), '\"') + "\"", this.jsonEngine));
    }

    private String escape(String value, char quote) {
        if (value == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                escape = !escape;
            } else if (ch == quote) {
                if (!escape) {
                    output.append('\\');
                }
            } else {
                escape = false;
            }
            output.append(ch);
        }
        return output.toString();
    }
}

