/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.impl;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.function.BiFunction;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.html.form.FormItemTo;
import com.restlet.client.html.form.FormItemType;
import com.restlet.client.model.EntityTo;
import com.restlet.client.net.http.request.HttpMethodDefinition;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.net.http.request.impl.EffectiveHttpRequestTo;
import com.restlet.client.net.request.RequestHeaderTo;
import com.restlet.client.net.uri.UriQueryParamTo;
import com.restlet.client.net.uri.UriSchemeTo;
import com.restlet.client.net.uri.UriTo;
import com.restlet.client.net.uri.UriUtils;
import com.restlet.client.net.uri.impl.UriSchemeToImpl;
import com.restlet.client.utils.EntityCloner;
import com.restlet.client.utils.FunctionalUtils;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Mutator;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class RequestProcessor {
    private final Function<String, String> encoder = new Function<String, String>(){

        @Override
        public String apply(String input) {
            return RequestProcessor.this.encodeQueryString(input);
        }
    };

    protected abstract Promise<String> process(String var1);

    protected abstract String encodeQueryString(String var1);

    public Promise<Boolean> isDynamic(EntityTo entity) {
        if (entity instanceof HttpRequestTo) {
            return this.process((HttpRequestTo)EntityCloner.ENTITY_CLONER.clone(entity)).map(new Function<EffectiveHttpRequestTo, Boolean>(){

                @Override
                public Boolean apply(EffectiveHttpRequestTo effectiveHttpRequestTo) {
                    return effectiveHttpRequestTo.isDynamic();
                }
            });
        }
        return Promises.of(entity.getType() == EntityTo.Type.Scenario);
    }

    private boolean isLocal(HttpRequestTo request) {
        return request != null && UriUtils.isLoopbackAddress(request.getUri());
    }

    @Mutator
    public Promise<EffectiveHttpRequestTo> process(final HttpRequestTo requestTo) {
        if (requestTo == null) {
            return Promises.of();
        }
        return this.evaluate(requestTo).map(new Function<Integer, EffectiveHttpRequestTo>(){

            @Override
            public EffectiveHttpRequestTo apply(Integer nbEvaluatedExpressions) {
                return new EffectiveHttpRequestTo(requestTo, nbEvaluatedExpressions > 0, RequestProcessor.this.isLocal(requestTo));
            }
        });
    }

    private Promise<Integer> evaluate(HttpRequestTo effective) {
        ArrayList nbDynamicExpressionsPromises = new ArrayList();
        nbDynamicExpressionsPromises.add(this.evaluateUri(effective.getUri()));
        nbDynamicExpressionsPromises.add(this.evaluateMethod(effective.getMethod()));
        nbDynamicExpressionsPromises.add(this.evaluateHeaders(effective.getHeaders()));
        nbDynamicExpressionsPromises.add(this.evaluateBody(effective));
        return Promises.all(nbDynamicExpressionsPromises).map(new Function<List<Integer>, Integer>(){

            @Override
            public Integer apply(List<Integer> input) {
                return Sequence.of(input).reduce(new BiFunction<Integer, Integer, Integer>(){

                    @Override
                    public Integer apply(Integer nbTotalDynamicExpressions, Integer nbDynamicExpressions) {
                        return nbTotalDynamicExpressions + nbDynamicExpressions;
                    }
                }, 0);
            }
        });
    }

    private Promise<Integer> evaluateMethod(final HttpMethodDefinition method) {
        if (method == null || !method.isCustom()) {
            return Promises.of(0);
        }
        return this.process(method.getName()).map(new Function<String, Integer>(){

            @Override
            public Integer apply(String evaluatedExpression) {
                String originalMethodName = method.getName();
                method.setName(FunctionalUtils.ifNotNull(evaluatedExpression, new Function<String, String>(){

                    @Override
                    public String apply(String input) {
                        return input.toUpperCase();
                    }
                }));
                return Objects.equals(originalMethodName, evaluatedExpression) ? 0 : 1;
            }
        });
    }

    private Promise<Integer> evaluateBody(final HttpRequestTo effective) {
        if (effective.getBody() == null || effective.getBody().getBodyType() == null && !effective.isBodyEvaluationDisabled()) {
            return Promises.of(0);
        }
        ArrayList<Promise<Boolean>> dynamicExpressionsPromises = new ArrayList<Promise<Boolean>>();
        switch (effective.getBody().getBodyType()) {
            case File: {
                break;
            }
            case Form: {
                if (effective.getBody().getFormBody() == null || Objects.isNullOrEmpty(effective.getBody().getFormBody().getItems())) break;
                for (final FormItemTo item : effective.getBody().getFormBody().getItems()) {
                    if (item == null || !item.isEnabled()) continue;
                    if (!StringUtils.isBlank(item.getName())) {
                        dynamicExpressionsPromises.add(this.process(item.getName()).map(new Function<String, Boolean>(){

                            @Override
                            public Boolean apply(String evaluatedExpression) {
                                String originalValue = item.getName();
                                item.setName(evaluatedExpression);
                                return !Objects.equals(originalValue, evaluatedExpression);
                            }
                        }));
                    }
                    if (FormItemType.Text.equals((Object)item.getType()) && !StringUtils.isBlank(item.getValue())) {
                        dynamicExpressionsPromises.add(this.process(item.getValue()).map(new Function<String, Boolean>(){

                            @Override
                            public Boolean apply(String evaluatedExpression) {
                                String originalValue = item.getValue();
                                item.setValue(evaluatedExpression);
                                return !Objects.equals(originalValue, evaluatedExpression);
                            }
                        }));
                        continue;
                    }
                    if (!FormItemType.File.equals((Object)item.getType())) continue;
                }
                break;
            }
            case Text: {
                if (StringUtils.isBlank(effective.getBody().getTextBody())) break;
                dynamicExpressionsPromises.add(this.process(effective.getBody().getTextBody()).map(new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String evaluatedExpression) {
                        String originalValue = effective.getBody().getTextBody();
                        effective.getBody().setTextBody(evaluatedExpression);
                        return !Objects.equals(originalValue, evaluatedExpression);
                    }
                }));
            }
        }
        return this.getNumberOfDynamicExpressions(dynamicExpressionsPromises);
    }

    private Promise<Integer> evaluateHeaders(List<RequestHeaderTo> headers) {
        if (Objects.isNullOrEmpty(headers)) {
            return Promises.of(0);
        }
        ArrayList<Promise<Boolean>> dynamicExpressionsPromises = new ArrayList<Promise<Boolean>>();
        for (final RequestHeaderTo header : headers) {
            if (header == null || !header.isEnabled()) continue;
            if (!StringUtils.isBlank(header.getName())) {
                final String headerName = header.getName();
                dynamicExpressionsPromises.add(this.process(header.getName()).map(new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String evaluatedExpression) {
                        header.setName(evaluatedExpression);
                        return !Objects.equals(headerName, evaluatedExpression);
                    }
                }));
            }
            if (StringUtils.isBlank(header.getValue())) continue;
            final String headerValue = header.getValue();
            dynamicExpressionsPromises.add(this.process(header.getValue()).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    header.setValue(evaluatedExpression);
                    return !Objects.equals(headerValue, evaluatedExpression);
                }
            }));
        }
        return this.getNumberOfDynamicExpressions(dynamicExpressionsPromises);
    }

    private Promise<Integer> evaluateUri(final UriTo requestUri) {
        if (requestUri == null) {
            return Promises.of(0);
        }
        ArrayList<Promise<Boolean>> dynamicExpressionsPromises = new ArrayList<Promise<Boolean>>();
        final UriSchemeTo originalScheme = requestUri.getScheme();
        if (originalScheme != null && !UriSchemeToImpl.isSupportedScheme(originalScheme)) {
            dynamicExpressionsPromises.add(this.process(originalScheme.getName()).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedScheme) {
                    if (UriSchemeToImpl.isSupportedScheme(evaluatedScheme)) {
                        requestUri.setScheme(UriSchemeToImpl.valueOf(evaluatedScheme));
                        return true;
                    }
                    requestUri.setScheme(null);
                    return !Objects.equals(evaluatedScheme, originalScheme.getName());
                }
            }));
        }
        if (!StringUtils.isBlank(requestUri.getHost())) {
            dynamicExpressionsPromises.add(this.process(requestUri.getHost()).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    String originalValue = requestUri.getHost();
                    requestUri.setHost(evaluatedExpression);
                    return !Objects.equals(originalValue, evaluatedExpression);
                }
            }));
        }
        if (!StringUtils.isBlank(requestUri.getPath())) {
            dynamicExpressionsPromises.add(this.process(requestUri.getPath()).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    String originalValue = requestUri.getPath();
                    requestUri.setPath(evaluatedExpression);
                    return !Objects.equals(originalValue, evaluatedExpression);
                }
            }));
        }
        if (!StringUtils.isBlank(requestUri.getFragment())) {
            dynamicExpressionsPromises.add(this.process(requestUri.getFragment()).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    String originalValue = requestUri.getFragment();
                    requestUri.setFragment(evaluatedExpression);
                    return !Objects.equals(originalValue, evaluatedExpression);
                }
            }));
        }
        if (requestUri.getQuery() != null && !Objects.isNullOrEmpty(requestUri.getQuery().getItems())) {
            for (final UriQueryParamTo qp : requestUri.getQuery().getItems()) {
                if (qp == null || !qp.isEnabled() || StringUtils.isBlank(qp.getName())) continue;
                dynamicExpressionsPromises.add(Promises.combine(this.process(qp.getName()), this.process(qp.getValue()), new Promises.CombineCallback<String, String, Boolean>(){

                    @Override
                    public Boolean on(String name, String value) {
                        boolean isDynamic;
                        boolean bl = isDynamic = !Objects.equals(qp.getName(), name) || !Objects.equals(qp.getValue(), value);
                        if (qp.isEncoded()) {
                            qp.setName(name);
                            qp.setValue(value);
                        } else {
                            qp.setName(Maybe.ofThrowable(RequestProcessor.this.encoder, name).orElse(name));
                            qp.setValue(Maybe.ofThrowable(RequestProcessor.this.encoder, value).orElse(value));
                        }
                        return isDynamic;
                    }
                }));
            }
        }
        return this.getNumberOfDynamicExpressions(dynamicExpressionsPromises).doOnResolve(new Consumer<Integer>(){

            @Override
            public void consume(Integer whatever) {
                UriUtils.ensureSchemeIsSet(requestUri);
            }
        });
    }

    private Promise<Integer> getNumberOfDynamicExpressions(List<Promise<Boolean>> dynamicExpressionsPromises) {
        return Promises.all(dynamicExpressionsPromises).map(new Function<List<Boolean>, Integer>(){

            @Override
            public Integer apply(List<Boolean> dynamicExpressions) {
                return Sequence.of(dynamicExpressions).filter(new Predicate<Boolean>(){

                    @Override
                    public boolean test(Boolean isDynamic) {
                        return isDynamic;
                    }
                }).count();
            }
        });
    }
}

