/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.impl;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.dao.EnvironmentsDao;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.html.form.FormItemTo;
import com.restlet.client.html.form.FormItemType;
import com.restlet.client.model.EntityTo;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.net.http.request.impl.EffectiveHttpRequestTo;
import com.restlet.client.script.ScriptService;
import com.restlet.client.script.impl.RequestProcessor;
import com.restlet.client.utils.EntityCloner;
import com.restlet.client.utils.Objects;
import java.util.List;

public abstract class ExpressionRequestEvaluator {
    private final EnvironmentsDao environmentsDao;
    private final ScriptService scriptService;

    public ExpressionRequestEvaluator(EnvironmentsDao environmentsDao, ScriptService scriptService) {
        this.environmentsDao = environmentsDao;
        this.scriptService = scriptService;
    }

    protected abstract String encodeQueryString(String var1);

    public Promise<EffectiveHttpRequestTo> effective(HttpRequestTo requestTo, RepositoryDao repositoryDao) {
        if (requestTo == null) {
            return Promises.of();
        }
        return this.getRequestEvaluator(repositoryDao).process(this.clone(requestTo));
    }

    public Promise<Boolean> isDynamic(EntityTo entity, RepositoryDao repositoryDao) {
        return this.getRequestEvaluator(repositoryDao).isDynamic(entity);
    }

    private HttpRequestTo clone(HttpRequestTo requestTo) {
        HttpRequestTo effective = EntityCloner.ENTITY_CLONER.clone(requestTo);
        if (effective.getBody() != null && effective.getBody().getBodyType() != null) {
            switch (effective.getBody().getBodyType()) {
                case File: {
                    effective.getBody().setFileBody(requestTo.getBody().getFileBody());
                    break;
                }
                case Form: {
                    if (effective.getBody().getFormBody() == null || Objects.isNullOrEmpty(effective.getBody().getFormBody().getItems())) break;
                    List<FormItemTo> bodyItems = effective.getBody().getFormBody().getItems();
                    for (int index = 0; index < bodyItems.size(); ++index) {
                        FormItemTo currentItem = bodyItems.get(index);
                        if (currentItem == null || !currentItem.isEnabled() || currentItem.getType() != FormItemType.File) continue;
                        currentItem.setBlobValue(requestTo.getBody().getFormBody().getItems().get(index).getBlobValue());
                    }
                    break;
                }
            }
        }
        return effective;
    }

    private RequestProcessor getRequestEvaluator(final RepositoryDao repositoryDao) {
        return new RequestProcessor(){

            @Override
            protected String encodeQueryString(String query) {
                return ExpressionRequestEvaluator.this.encodeQueryString(query);
            }

            @Override
            protected Promise<String> process(String value) {
                return ExpressionRequestEvaluator.this.scriptService.evaluate(value, ExpressionRequestEvaluator.this.environmentsDao, repositoryDao);
            }
        };
    }
}

