/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.platform.crypto;

import com.restlet.client.platform.CryptoApi;

public abstract class AbstractCryptoImpl
implements CryptoApi {
    @Override
    public String hash(CryptoApi.HashType hashType, String message, CryptoApi.Output out) {
        String hash = hashType == null ? null : hashType.algorithm;
        String output = out == null ? null : out.label;
        return this.getHash(message, hash, output);
    }

    @Override
    public String hmac(CryptoApi.HashType hashType, String secret, String message, CryptoApi.Output out) {
        String hash = hashType == null ? null : hashType.algorithm;
        String output = out == null ? null : out.label;
        return this.getHMAC(secret, message, hash, output);
    }

    @Override
    public String encrypt(CryptoApi.CipherType type, String message, String secret) {
        if (type == null) {
            throw new IllegalArgumentException("The argument cipher type is missing");
        }
        switch (type) {
            case AES: {
                return this.encryptAES(message, secret);
            }
        }
        throw new IllegalStateException("The cipher type '" + (Object)((Object)type) + "' is not supported.");
    }

    @Override
    public String decrypt(CryptoApi.CipherType type, String message, String secret) {
        if (type == null) {
            throw new IllegalArgumentException("The argument cipher type is missing");
        }
        switch (type) {
            case AES: {
                return this.decryptAES(message, secret);
            }
        }
        throw new IllegalStateException("The cipher type '" + (Object)((Object)type) + "' is not supported.");
    }

    protected abstract String encryptAES(String var1, String var2);

    protected abstract String decryptAES(String var1, String var2);

    protected abstract String getHMAC(String var1, String var2, String var3, String var4);

    protected abstract String getHash(String var1, String var2, String var3);
}

