/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.net.http.request;

import com.restlet.client.function.Predicate;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;

public enum HttpVersion {
    V11("v1.1", "HTTP/1.1"),
    V10("v1.0", "HTTP/1.0"),
    V09("v0.9", "HTTP/0.9");

    private final String asString;
    private final String httpVersion;

    private HttpVersion(String asString, String httpVersion) {
        this.asString = asString;
        this.httpVersion = httpVersion;
    }

    public String toString() {
        return this.asString;
    }

    public static HttpVersion lookup(final String version) {
        return Sequence.of(HttpVersion.values()).filter(new Predicate<HttpVersion>(){

            @Override
            public boolean test(HttpVersion httpVersion) {
                return Objects.equals(version, httpVersion.asString) || Objects.equals(version, httpVersion.httpVersion);
            }
        }).first().get();
    }
}

