/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.model.impl;

import com.restlet.client.model.EntityTo;
import com.restlet.client.model.ProjectTo;
import com.restlet.client.model.ServiceTo;
import com.restlet.client.model.environment.EnvironmentTo;
import com.restlet.client.model.impl.ProjectToImpl;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.platform.json.JsonArray;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonException;
import com.restlet.client.platform.json.JsonObject;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.tests.ScenarioTo;
import com.restlet.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImportParserImpl {
    private final JsonEngine jsonEngine;

    public ImportParserImpl(JsonEngine jsonEngine) {
        this.jsonEngine = jsonEngine;
    }

    public String findFileVersion(String fileContent) {
        try {
            return this.jsonEngine.fromJson(fileContent).isObject().get("front-version").isString().stringValue();
        }
        catch (Throwable e) {
            return "1.3.5 or earlier";
        }
    }

    public Map<String, EntityTo> parse(String o) throws JsonException {
        JsonValue repository = this.jsonEngine.fromJson(o);
        if (repository == null) {
            return null;
        }
        JsonObject repo = repository.isObject();
        if (repo == null) {
            return null;
        }
        if (!repo.containsKey("version") || repo.get("version") == null || repo.get("version").isNumber() == null) {
            return null;
        }
        int version = (int)repo.get("version").isNumber().doubleValue();
        if (version < 3) {
            return null;
        }
        if (repo.get("nodes") == null) {
            return null;
        }
        JsonArray nodes = repo.get("nodes").isArray();
        if (nodes == null) {
            return null;
        }
        ArrayList<JsonObject> repositoryNodes = new ArrayList<JsonObject>();
        for (int i = 0; i < nodes.size(); ++i) {
            JsonObject obj = nodes.get(i).isObject();
            if (obj == null) continue;
            repositoryNodes.add(obj);
        }
        HashMap<String, EntityTo> entities = new HashMap<String, EntityTo>();
        for (JsonObject repositoryNode : repositoryNodes) {
            EntityTo entity = this.getEntity(repositoryNode);
            if (entity == null) continue;
            entities.put(entity.getId(), entity);
        }
        for (EntityTo entityTo : entities.values()) {
            String parentId;
            EntityTo parent = entityTo.getParent();
            if (parent == null || StringUtils.isBlank(parentId = parent.getId())) continue;
            entityTo.setParent((EntityTo)entities.get(parentId));
        }
        return entities;
    }

    private EntityTo getEntity(JsonObject object) throws JsonException {
        String parentId;
        String type;
        String string = type = object.get("type") != null && object.get("type").isString() != null ? object.get("type").isString().stringValue() : null;
        if (StringUtils.isBlank(type)) {
            return null;
        }
        EntityTo.Type entityType = EntityTo.Type.valueOf(type);
        EntityTo entity = null;
        switch (entityType) {
            case Context: {
                entity = this.jsonEngine.fromJson(this.jsonEngine.toJson(object), EnvironmentTo.class);
                break;
            }
            case Project: {
                entity = this.jsonEngine.fromJson(this.jsonEngine.toJson(object), ProjectTo.class);
                break;
            }
            case Request: {
                entity = this.jsonEngine.fromJson(this.jsonEngine.toJson(object), HttpRequestTo.class);
                break;
            }
            case Service: {
                entity = this.jsonEngine.fromJson(this.jsonEngine.toJson(object), ServiceTo.class);
                break;
            }
            case Scenario: {
                entity = this.jsonEngine.fromJson(this.jsonEngine.toJson(object), ScenarioTo.class);
            }
        }
        if (entity == null) {
            return null;
        }
        String string2 = parentId = object.get("parentId") != null && object.get("parentId").isString() != null ? object.get("parentId").isString().stringValue() : null;
        if (StringUtils.isBlank(parentId)) {
            entity.setParent(null);
        } else {
            ProjectToImpl parent = new ProjectToImpl();
            parent.setId(parentId);
            entity.setParent(parent);
        }
        return entity;
    }
}

