/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.model;

import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.model.EntityTo;
import com.restlet.client.model.EntityTreeNode;
import com.restlet.client.utils.EntityUtils;
import com.restlet.client.utils.FunctionalUtils;
import com.restlet.client.utils.Holder;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public enum UpdateStatus {
    REQUEST_ORDER_WARNING{

        @Override
        public String generateHtmlErrorMessage(List<EntityTreeNode> incriminatedElements) {
            return StringUtils.format("<p>An issue has been detected with your data.<br>Please double check that the requests of the following imported scenarios are correctly ordered:</p><ul>%s</ul>", StringUtils.joiner(Sequence.of(incriminatedElements).map(new Function<EntityTreeNode, String>(){

                @Override
                public String apply(EntityTreeNode entityTreeNode) {
                    final ArrayList names = new ArrayList();
                    EntityUtils.walkEntityAndParents(entityTreeNode.entity, new Consumer<EntityTo>(){

                        @Override
                        public void consume(EntityTo entityTo) {
                            names.add(0, "\"" + entityTo.getName() + "\"");
                        }
                    });
                    return StringUtils.format("<li>%s</li>", StringUtils.joiner(names).joinWith(" / "));
                }
            }).toList()).joinWith(""));
        }
    };


    public abstract String generateHtmlErrorMessage(List<EntityTreeNode> var1);

    public static Map<UpdateStatus, List<EntityTreeNode>> indexTreeNodesByUpdateStatus(Holder<EntityTreeNode> persistedNodeHolder) {
        final Map<UpdateStatus, List<EntityTreeNode>> map = Sequence.of(UpdateStatus.values()).toMap(FunctionalUtils.identity(), new Function<UpdateStatus, List<EntityTreeNode>>(){

            @Override
            public List<EntityTreeNode> apply(UpdateStatus updateStatus) {
                return new ArrayList<EntityTreeNode>();
            }
        });
        ((EntityTreeNode)persistedNodeHolder.value).walk(new Consumer<EntityTreeNode>(){

            @Override
            public void consume(EntityTreeNode node) {
                if (node.updateStatus != null) {
                    ((List)map.get((Object)node.updateStatus)).add(node);
                }
            }
        });
        return map;
    }
}

