/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.model;

import com.restlet.client.function.BiConsumer;
import com.restlet.client.function.BiFunction;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.model.EntityTo;
import com.restlet.client.model.UpdateStatus;
import com.restlet.client.model.UpdateType;
import com.restlet.client.model.impl.EntityToImpl;
import com.restlet.client.tests.ScenarioTo;
import com.restlet.client.utils.ComparatorUtils;
import com.restlet.client.utils.ListUtils;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EntityTreeNode {
    public final EntityTo entity;
    public final List<EntityTreeNode> children = new ArrayList<EntityTreeNode>();
    public UpdateType updateType;
    public UpdateStatus updateStatus;

    @Deprecated
    public EntityTreeNode() {
        this.entity = new EntityToImpl();
    }

    public EntityTreeNode(EntityTo entity) {
        this.entity = entity;
        this.updateType = UpdateType.None;
    }

    public EntityTreeNode(EntityTo entity, UpdateType updateType, EntityTreeNode ... children) {
        this(entity);
        this.updateType = updateType;
        for (EntityTreeNode child : children) {
            this.addChild(child);
        }
    }

    public EntityTreeNode setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
        return this;
    }

    public EntityTreeNode setUpdateStatus(UpdateStatus updateStatus) {
        this.updateStatus = updateStatus;
        return this;
    }

    public EntityTreeNode addChild(EntityTreeNode child) {
        this.children.add(child);
        return this;
    }

    public EntityTreeNode addChildren(Collection<EntityTreeNode> children) {
        this.children.addAll(children);
        return this;
    }

    public String toString() {
        return "ProjectTreeNode{entity=" + this.entity + ", children=" + this.children + ", updateType=" + (Object)((Object)this.updateType) + '}';
    }

    public EntityTreeNode retrieveChildByName(String entityName) {
        for (EntityTreeNode child : this.children) {
            if (!entityName.equals(child.entity.getName())) continue;
            return child;
        }
        throw new IllegalArgumentException("Child named '" + entityName + "' not found.");
    }

    public EntityTreeNode retrieveChildById(String id) {
        for (EntityTreeNode child : this.children) {
            if (!id.equals(child.entity.getId())) continue;
            return child;
        }
        throw new IllegalArgumentException("Child with id '" + id + "' not found.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTreeNode other = (EntityTreeNode)o;
        return this.entity.equals(other.entity) && this.children.equals(other.children) && this.updateType == other.updateType;
    }

    public int hashCode() {
        int result = this.entity.hashCode();
        result = 31 * result + this.children.hashCode();
        result = 31 * result + (this.updateType != null ? this.updateType.hashCode() : 0);
        return result;
    }

    public List<EntityTo> flattenEntitiesRecursively() {
        return this.reduce(new Function<EntityTreeNode, Maybe<EntityTo>>(){

            @Override
            public Maybe<EntityTo> apply(EntityTreeNode node) {
                return Maybe.of(node.entity);
            }
        });
    }

    public List<EntityTo> retrieveAllChildrenRecursively() {
        return Sequence.of(this.children).flatMap(new Function<EntityTreeNode, Iterable<EntityTo>>(){

            @Override
            public Iterable<EntityTo> apply(EntityTreeNode input) {
                return input.flattenEntitiesRecursively();
            }
        }).toList();
    }

    public Maybe<EntityTreeNode> find(final Function<EntityTreeNode, Boolean> filter) {
        final ArrayList<EntityTreeNode> candidates = new ArrayList<EntityTreeNode>();
        if (filter.apply(this).booleanValue()) {
            candidates.add(this);
        }
        Sequence.of(this.children).omitNulls().each(new BiConsumer<EntityTreeNode, Integer>(){

            @Override
            public void consume(EntityTreeNode child, Integer index) {
                child.find(filter).ifPresent(new Consumer<EntityTreeNode>(){

                    @Override
                    public void consume(EntityTreeNode foundCandidate) {
                        candidates.add(foundCandidate);
                    }
                });
            }
        });
        if (candidates.isEmpty()) {
            return Maybe.empty();
        }
        if (candidates.size() == 1) {
            return Maybe.of(ListUtils.first(candidates));
        }
        throw new IllegalArgumentException("Cannot find a node corresponding to the search.");
    }

    public EntityTreeNode walk(final Consumer<EntityTreeNode> visitor) {
        visitor.consume(this);
        Sequence.of(this.children).each(new BiConsumer<EntityTreeNode, Integer>(){

            @Override
            public void consume(EntityTreeNode child, Integer index) {
                child.walk(visitor);
            }
        });
        return this;
    }

    public void walkChildrenWithParent(final BiConsumer<EntityTreeNode, EntityTreeNode> visitor) {
        Sequence.of(this.children).each(new BiConsumer<EntityTreeNode, Integer>(){

            @Override
            public void consume(EntityTreeNode child, Integer index) {
                visitor.consume(EntityTreeNode.this, child);
                child.walkChildrenWithParent(visitor);
            }
        });
    }

    public EntityTreeNode recursiveSetUpdateType(final UpdateType newUpdateType) {
        this.walk(new Consumer<EntityTreeNode>(){

            @Override
            public void consume(EntityTreeNode node) {
                node.setUpdateType(newUpdateType);
            }
        });
        return this;
    }

    public <T> List<T> reduce(final Function<EntityTreeNode, Maybe<T>> reducer) {
        final ArrayList result = new ArrayList();
        reducer.apply(this).ifPresent(new Consumer<T>(){

            @Override
            public void consume(T value) {
                result.add(value);
            }
        });
        Sequence.of(this.children).each(new BiConsumer<EntityTreeNode, Integer>(){

            @Override
            public void consume(EntityTreeNode child, Integer index) {
                result.addAll(child.reduce(reducer));
            }
        });
        return result;
    }

    public Maybe<EntityTreeNode> searchRecursively(EntityTo another, BiFunction<EntityTo, EntityTo, Boolean> matcher) {
        if (matcher.apply(this.entity, another).booleanValue()) {
            return Maybe.of(this);
        }
        if (this.children.isEmpty()) {
            return Maybe.empty();
        }
        for (EntityTreeNode child : this.children) {
            Maybe<EntityTreeNode> match = child.searchRecursively(another, matcher);
            if (!match.isPresent()) continue;
            return match;
        }
        return Maybe.empty();
    }

    public void sortChildrenByName() {
        if (this.entity instanceof ScenarioTo) {
            ComparatorUtils.sortAsScenarioRequests(this.children, (ScenarioTo)this.entity, new Function<EntityTreeNode, String>(){

                @Override
                public String apply(EntityTreeNode treeNode) {
                    return treeNode.entity.getName();
                }
            });
        } else {
            Collections.sort(this.children, new Comparator<EntityTreeNode>(){

                @Override
                public int compare(EntityTreeNode node1, EntityTreeNode node2) {
                    return node1.entity.getName().compareTo(node2.entity.getName());
                }
            });
        }
        for (EntityTreeNode child : this.children) {
            child.sortChildrenByName();
        }
    }

    public void sortChildrenById() {
        Collections.sort(this.children, new Comparator<EntityTreeNode>(){

            @Override
            public int compare(EntityTreeNode node1, EntityTreeNode node2) {
                return node1.entity.getId().compareTo(node2.entity.getId());
            }
        });
    }
}

