/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.commons;

import com.restlet.client.utils.Objects;
import com.restlet.client.utils.StringUtils;

public abstract class AppConstants {
    public static String getClientName() {
        return "client";
    }

    public static String getProviderDomain() {
        return "client.restlet.com";
    }

    public static String getTwitterId() {
        return "restlet";
    }

    public static String getSupportEmail() {
        return "support@restlet.com";
    }

    public static String getTwitterUrl() {
        return "https://twitter.com/restlet";
    }

    public static String getClientModuleName() {
        return "Restlet Client";
    }

    static String getClientDocumentationUrl() {
        return "https://restlet.com/documentation/client/user-guide/get-started/launch";
    }

    static String getMavenPluginDocumentationUrl() {
        return AppConstants.getClientDocumentationUrl() + "/run-tests/automate-tests/test-reports-maven";
    }

    public static String getMavenPluginNexusUrl() {
        return "http://maven.restlet.com/com/restlet/client/maven-plugin";
    }

    static String getClientPageUrl() {
        return "https://restlet.com/modules/client";
    }

    static String getClientAppUrl() {
        return "https://client.restlet.com";
    }

    static String getStudioModuleName() {
        return "Restlet Studio";
    }

    static String getStudioPageUrl() {
        return "https://restlet.com/modules/studio";
    }

    static String getStudioAppUrl() {
        return "https://studio.restlet.com";
    }

    static String getCloudModuleName() {
        return "Restlet Cloud";
    }

    static String getCloudPageUrl() {
        return "https://restlet.com/modules/cloud";
    }

    static String getCloudAppUrl() {
        return "https://cloud.restlet.com";
    }

    public static String getChromeExtensionUrl() {
        return "https://chrome.google.com/webstore/detail/restlet-client/aejoelaoggembcahagimdiliamlcdmfm";
    }

    public static String getChromeExtensionReviewsUrl() {
        return AppConstants.getChromeExtensionUrl() + "/reviews";
    }

    public static String getSystinetName() {
        return "HP Systinet";
    }

    public static String getSwaggerName() {
        return "Swagger";
    }

    public static String getHarName() {
        return "HAR";
    }

    public static String getMixpanelInitialReferrerDomainForRestletClientProduct() {
        return "chrome.google.com";
    }

    public static String getMixpanelInitialReferrerDomainForOtherPlatformProducts() {
        return "restlet.com";
    }

    public static enum ExternalLink {
        AddChromeReview(AppConstants.getChromeExtensionReviewsUrl(), "writing a review", false),
        ClientExtension(AppConstants.getChromeExtensionUrl(), AppConstants.getClientModuleName(), false),
        ClientDocumentation(AppConstants.getClientDocumentationUrl(), "Documentation", true),
        ClientMavenPluginDocumentation(AppConstants.getMavenPluginDocumentationUrl(), "Maven documentation", true),
        ClientPage(AppConstants.getClientPageUrl(), AppConstants.getClientModuleName(), true),
        ClientApp(AppConstants.getClientAppUrl(), AppConstants.getClientModuleName(), false),
        CloudPage(AppConstants.getCloudPageUrl(), AppConstants.getCloudModuleName(), true),
        CloudApp(AppConstants.getCloudAppUrl(), AppConstants.getCloudModuleName(), false),
        StudioPage(AppConstants.getStudioPageUrl(), AppConstants.getStudioModuleName(), true),
        StudioApp(AppConstants.getStudioAppUrl(), AppConstants.getStudioModuleName(), false);

        public final String label;
        public final String baseLink;
        public final boolean shouldAddUtm;

        private ExternalLink(String baseLink, String label, boolean shouldAddUtm) {
            this.baseLink = baseLink;
            this.label = label;
            this.shouldAddUtm = shouldAddUtm;
        }

        public String getUrl(String subLink) {
            Objects.requireNonNull(subLink);
            return StringUtils.format("%s%s%s", this.baseLink, subLink, this.shouldAddUtm ? "?utm_source=DHC" : "");
        }
    }
}

