/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.async.impl;

import com.restlet.client.async.AsyncStreamWithResult;
import com.restlet.client.async.Deferred;
import com.restlet.client.async.Promise;
import com.restlet.client.async.PromiseHandler;
import com.restlet.client.async.Promises;
import com.restlet.client.async.impl.DeferredImpl;
import com.restlet.client.function.Consumer;
import com.restlet.client.utils.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class WritableStreamWithResult<T, R>
implements AsyncStreamWithResult<T, R> {
    private final List<T> stack = new ArrayList<T>();
    private final List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();
    private final Deferred<R> closeDeferred;

    public WritableStreamWithResult() {
        this(Collections.emptyList());
    }

    private WritableStreamWithResult(List<T> initialValue) {
        this.stack.addAll(initialValue);
        this.closeDeferred = new DeferredImpl<R>();
    }

    public void accept(List<T> list) throws IllegalStateException {
        for (T val : list) {
            this.accept(val);
        }
    }

    public void accept(T value) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Stream is closed");
        }
        if (this.consumers.isEmpty()) {
            this.stack.add(value);
        } else {
            for (Consumer<T> consumer : this.consumers) {
                this.consume(consumer, value);
            }
        }
    }

    @Override
    public AsyncStreamWithResult<T, R> forEach(Consumer<T> consumer) {
        if (!this.isClosed()) {
            this.consumers.add(consumer);
        }
        if (this.stack.isEmpty()) {
            return this;
        }
        Iterator<T> iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            iterator.remove();
            this.consume(consumer, next);
        }
        return this;
    }

    private void consume(Consumer<T> consumer, T value) {
        try {
            consumer.consume(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Promise<List<T>> asList() {
        final ArrayList returnValue = new ArrayList();
        if (this.isClosed()) {
            return Promises.of(returnValue);
        }
        this.forEach(new Consumer<T>(){

            @Override
            public void consume(T t) {
                returnValue.add(t);
            }
        });
        return this.closeDeferred.promise().then(new PromiseHandler<Object>(){

            @Override
            @Nullable
            public Object on(@Nullable Object param) {
                return returnValue;
            }
        });
    }

    @Override
    public AsyncStreamWithResult<T, R> closeIfStillOpened(R result) {
        if (!this.isClosed()) {
            this.closeDeferred.resolve(result);
        }
        return this;
    }

    @Override
    public void closeIfStillOpened(Throwable e) {
        if (!this.isClosed()) {
            this.closeDeferred.reject(e);
        }
    }

    @Override
    public void closeWhen(Promise<R> closePromise) {
        closePromise.doOnResolve(new Consumer<R>(){

            @Override
            public void consume(R result) {
                WritableStreamWithResult.this.closeIfStillOpened(result);
            }
        }).doOnReject(new Consumer<Throwable>(){

            @Override
            public void consume(Throwable throwable) {
                WritableStreamWithResult.this.closeIfStillOpened(throwable);
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closeDeferred.getState() != Deferred.State.PENDING;
    }

    @Override
    public Promise<R> closePromise() {
        return this.closeDeferred.promise();
    }
}

