/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.async.impl;

import com.restlet.client.async.Deferred;
import com.restlet.client.async.Promise;
import com.restlet.client.async.PromiseHandler;
import com.restlet.client.async.Promises;
import com.restlet.client.async.impl.DeferredImpl;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.utils.Holder;
import com.restlet.client.utils.NotNull;
import com.restlet.client.utils.Nullable;

public class PromiseImpl<C>
implements Promise<C> {
    private final Deferred<C> deferred;

    PromiseImpl(Deferred<C> deferred) {
        this.deferred = deferred;
    }

    protected static void link(Promise from, final Deferred to) {
        if (from == null) {
            to.resolve(null);
            return;
        }
        if (to.getState() != Deferred.State.PENDING) {
            return;
        }
        if (!from.isDone()) {
            from.getDeferred().addDeferredResolvedHandler(new Deferred.DeferredResolvedHandler(){

                public void onResolve(Deferred resolvedDeferred) {
                    if (to.getState() != Deferred.State.PENDING) {
                        return;
                    }
                    if (resolvedDeferred.getState() == Deferred.State.ERROR) {
                        to.reject(resolvedDeferred.getError());
                    } else if (resolvedDeferred.getState() == Deferred.State.SUCCESS) {
                        to.resolve(resolvedDeferred.getResult());
                    }
                }
            });
        } else {
            Deferred deferred1 = from.getDeferred();
            if (deferred1.getState() == Deferred.State.ERROR) {
                to.reject(deferred1.getError());
            } else if (deferred1.getState() == Deferred.State.SUCCESS) {
                to.resolve(deferred1.getResult());
            }
        }
    }

    @Override
    public <T> Promise<T> then(@NotNull PromiseHandler successHandler) {
        return this.then(successHandler, null);
    }

    @Override
    public <T> Promise<T> then(final @Nullable PromiseHandler successHandler, final @Nullable PromiseHandler<Throwable> errorHandler) {
        if (successHandler == null && errorHandler == null) {
            throw new IllegalArgumentException("At least one of the handlers should be not null");
        }
        final DeferredImpl futureDeferred = new DeferredImpl();
        if (this.isDone()) {
            this.notifyHandlers(futureDeferred, successHandler, errorHandler);
        } else {
            this.deferred.addDeferredResolvedHandler(new Deferred.DeferredResolvedHandler(){

                public void onResolve(Deferred deferred) {
                    PromiseImpl.this.notifyHandlers(futureDeferred, successHandler, errorHandler);
                }
            });
        }
        return futureDeferred.promise();
    }

    private void notifyHandlers(Deferred futureDeferred, PromiseHandler successHandler, PromiseHandler<Throwable> errorHandler) {
        if (this.deferred.getState() == Deferred.State.SUCCESS) {
            if (successHandler != null) {
                try {
                    Object handlerPromise = successHandler.on(this.deferred.getResult());
                    PromiseImpl.link(Promises.when(handlerPromise), futureDeferred);
                }
                catch (Throwable e) {
                    futureDeferred.reject(e);
                }
            } else {
                futureDeferred.resolve(this.deferred.getResult());
            }
        } else if (this.deferred.getState() == Deferred.State.ERROR) {
            if (errorHandler != null) {
                try {
                    Object handlerPromise = errorHandler.on(this.deferred.getError());
                    PromiseImpl.link(Promises.when(handlerPromise), futureDeferred);
                }
                catch (Throwable e) {
                    futureDeferred.reject(e);
                }
            } else {
                futureDeferred.reject(this.deferred.getError());
            }
        }
    }

    @Override
    @Deprecated
    public <T> Promise<T> onError(@NotNull PromiseHandler<Throwable> errorHandler) {
        return this.then(null, errorHandler);
    }

    @Override
    public Promise<C> recoverOnReject(PromiseHandler<Throwable> errorHandler) {
        return this.then(null, errorHandler);
    }

    @Override
    public Promise<C> recoverOnReject(final Promise<C> promise) {
        return this.recoverOnReject((C)new PromiseHandler<Throwable>(){

            @Override
            public Object on(@Nullable Throwable error) {
                return promise;
            }
        });
    }

    @Override
    public Promise<C> recoverOnReject(final C value) {
        return this.recoverOnReject((C)new PromiseHandler<Throwable>(){

            @Override
            public Object on(@Nullable Throwable error) {
                return value;
            }
        });
    }

    @Override
    public Promise<C> recoverOnReject() {
        return this.recoverOnReject((C)new PromiseHandler<Throwable>(){

            @Override
            public Object on(@Nullable Throwable error) {
                return null;
            }
        });
    }

    @Override
    public <T> Promise<T> flatRecoverOnReject(final Function<Throwable, Promise<T>> handler) {
        return this.then(null, new PromiseHandler<Throwable>(){

            @Override
            public Object on(@Nullable Throwable error) {
                return handler.apply(error);
            }
        });
    }

    @Override
    public <T> Promise<T> cast() {
        return this;
    }

    @Override
    public boolean isDone() {
        return this.deferred.getState() != Deferred.State.PENDING;
    }

    @Override
    public <T> Promise<T> flatMap(final Function<C, Promise<T>> handler) {
        if (this.isDone()) {
            if (this.deferred.getState() == Deferred.State.SUCCESS) {
                try {
                    Promise<T> result = handler.apply(this.deferred.getResult());
                    if (result == null) {
                        return Promises.of();
                    }
                    return result;
                }
                catch (Throwable e) {
                    return Promises.reject(e);
                }
            }
            return Promises.reject(this.deferred.getError());
        }
        final DeferredImpl futureDeferred = new DeferredImpl();
        this.deferred.addDeferredResolvedHandler(new Deferred.DeferredResolvedHandler(){

            @Override
            public void onResolve(Deferred<?> deferred) {
                Deferred.State state = deferred.getState();
                if (state == Deferred.State.SUCCESS) {
                    try {
                        PromiseImpl.link((Promise)handler.apply(deferred.getResult()), futureDeferred);
                    }
                    catch (Throwable e) {
                        futureDeferred.reject(e);
                    }
                } else {
                    futureDeferred.reject(deferred.getError());
                }
            }
        });
        return futureDeferred.promise();
    }

    @Override
    public <T> Promise<T> flatMapIfNotNull(final Function<C, Promise<T>> handler) {
        return this.flatMap(new Function<C, Promise<T>>(){

            @Override
            public Promise<T> apply(C value) {
                if (value == null) {
                    return Promises.of();
                }
                return (Promise)handler.apply(value);
            }
        });
    }

    @Override
    public <T> Promise<T> flatMap(final Promise<T> promise) {
        return this.flatMap(new Function<C, Promise<T>>(){

            @Override
            public Promise<T> apply(C input) {
                return promise;
            }
        });
    }

    @Override
    public <T> Promise<T> map(final Function<C, T> handler) {
        return this.flatMap(new Function<C, Promise<T>>(){

            @Override
            public Promise<T> apply(C input) {
                return Promises.of(handler.apply(input));
            }
        });
    }

    @Override
    public <T> Promise<T> mapIfNotNull(final Function<C, T> handler) {
        return this.flatMap(new Function<C, Promise<T>>(){

            @Override
            public Promise<T> apply(C input) {
                if (input == null) {
                    return Promises.of();
                }
                return Promises.of(handler.apply(input));
            }
        });
    }

    @Override
    public Promise<C> doOnReject(final Consumer<Throwable> consumer) {
        try {
            if (this.getDeferred().getState() == Deferred.State.ERROR) {
                consumer.consume(this.getDeferred().getError());
            } else if (!this.isDone()) {
                this.deferred.addDeferredResolvedHandler(new Deferred.DeferredResolvedHandler(){

                    @Override
                    public void onResolve(Deferred<?> deferred) {
                        PromiseImpl.this.doOnReject(consumer);
                    }
                });
            }
        }
        catch (Throwable e) {
            DeferredImpl.LOG_SERVICE.error("Consumer threw an error when being notified of error", e);
        }
        return this;
    }

    @Override
    public Promise<C> doOnResolve(final Consumer<C> consumer) {
        return this.map(new Function<C, C>(){

            @Override
            public C apply(C input) {
                consumer.consume(input);
                return input;
            }
        });
    }

    @Override
    public Promise<C> doOnResolveIfNotNull(final Consumer<C> consumer) {
        return this.doOnResolve(new Consumer<C>(){

            @Override
            public void consume(C value) {
                if (value == null) {
                    return;
                }
                consumer.consume(value);
            }
        });
    }

    @Override
    public Promise<C> doFinally(final Consumer<Deferred> consumer) {
        try {
            if (this.isDone()) {
                consumer.consume(this.deferred);
            } else {
                this.deferred.addDeferredResolvedHandler(new Deferred.DeferredResolvedHandler(){

                    @Override
                    public void onResolve(Deferred<?> deferred) {
                        PromiseImpl.this.doFinally(consumer);
                    }
                });
            }
        }
        catch (Throwable e) {
            DeferredImpl.LOG_SERVICE.error("Consumer threw an error,when being notified of final state of promise", e);
        }
        return this;
    }

    @Override
    public Promise<Void> castToVoidPromise() {
        return this.map(new Function<C, Void>(){

            @Override
            public Void apply(C whatever) {
                return null;
            }
        });
    }

    @Override
    public Promise<C> assignTo(final Holder<C> parentValueHolder) {
        return this.map(new Function<C, C>(){

            @Override
            public C apply(C value) {
                parentValueHolder.value = value;
                return value;
            }
        });
    }

    @Override
    public Deferred getDeferred() {
        return this.deferred;
    }
}

