/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.async;

import com.restlet.client.async.Deferred;
import com.restlet.client.async.Promise;
import com.restlet.client.async.impl.DeferredImpl;
import com.restlet.client.function.BiConsumer;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Executor;
import com.restlet.client.function.Function;
import com.restlet.client.utils.Holder;
import com.restlet.client.utils.ListUtils;
import com.restlet.client.utils.Nullable;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class Promises {
    protected Promises() {
    }

    @Deprecated
    public static <F> Promise<F> when(Object promiseOrValue) {
        if (promiseOrValue instanceof Promise) {
            return (Promise)promiseOrValue;
        }
        DeferredImpl<Object> deferred = new DeferredImpl<Object>();
        deferred.resolve(promiseOrValue);
        return deferred.promise();
    }

    public static <F> Promise<List<F>> all(final List<Promise<F>> promises) {
        if (Objects.isNullOrEmpty(promises)) {
            return Promises.of(Collections.emptyList());
        }
        final Holder<Integer> counter = Holder.of(0);
        final DeferredImpl deferred = new DeferredImpl();
        final List<Object> values = ListUtils.newFilledList(promises.size(), null);
        Sequence.of(promises).each(new BiConsumer<Promise<F>, Integer>(){

            @Override
            public void consume(Promise<F> promise, final Integer index) {
                promise.doOnResolve(new Consumer<F>(){

                    @Override
                    public void consume(F result) {
                        values.set(index, result);
                        if (deferred.getState() == Deferred.State.PENDING) {
                            Integer n = (Integer)counter.value;
                            Holder holder = counter;
                            holder.value = (Integer)holder.value + 1;
                            Integer n2 = holder.value;
                            if (promises.size() == ((Integer)counter.value).intValue()) {
                                deferred.resolve(values);
                            }
                        }
                    }
                }).doOnReject(new Consumer<Throwable>(){

                    @Override
                    @Nullable
                    public void consume(@Nullable Throwable error) {
                        if (deferred.getState() == Deferred.State.PENDING) {
                            deferred.reject(error);
                        }
                    }
                });
            }
        });
        return deferred.promise();
    }

    public static <T> Promise<T> reject(Throwable e) {
        DeferredImpl deferred = new DeferredImpl();
        deferred.reject(e);
        return deferred.promise();
    }

    public static <T> Promise<T> reject(String warningMessage) {
        DeferredImpl deferred = new DeferredImpl();
        deferred.reject(warningMessage);
        return deferred.promise();
    }

    public static <F, S, R> Promise<R> combine(Promise<F> firstPromise, Promise<S> secondPromise, final CombineCallback<F, S, R> callback) {
        final Object[] vals = new Object[2];
        List<Promise<F>> safePromises = Arrays.asList(firstPromise.doOnResolve(new Consumer<F>(){

            @Override
            public void consume(@Nullable F value) {
                vals[0] = value;
            }
        }).castToVoidPromise(), secondPromise.doOnResolve(new Consumer<S>(){

            @Override
            public void consume(@Nullable S value) {
                vals[1] = value;
            }
        }).castToVoidPromise());
        return Promises.all(safePromises).map(new Function<List<Void>, R>(){

            @Override
            @Nullable
            public R apply(@Nullable List<Void> input) {
                return callback.on(vals[0], vals[1]);
            }
        });
    }

    public static <T> T get(Promise<T> promise) {
        final Holder result = Holder.empty();
        final Holder error = Holder.empty();
        if (!promise.isDone()) {
            throw new IllegalArgumentException("Promise should be in done state");
        }
        promise.doOnReject(new Consumer<Throwable>(){

            @Override
            public void consume(@Nullable Throwable e) {
                error.value = e;
            }
        });
        if (error.hasValue()) {
            throw new RuntimeException((Throwable)error.value);
        }
        promise.doOnResolve(new Consumer<T>(){

            @Override
            public void consume(@Nullable T value) {
                result.value = value;
            }
        });
        return result.value;
    }

    public static <T> Promise<T> create(Consumer<Deferred<T>> consumer) {
        DeferredImpl deferred = new DeferredImpl();
        try {
            consumer.consume(deferred);
        }
        catch (Throwable e) {
            if (deferred.getState() == Deferred.State.PENDING) {
                deferred.reject(e);
            }
            DeferredImpl.LOG_SERVICE.error("Promise creator threw an error after resolving/rejecting the promise", e);
        }
        return deferred.promise();
    }

    public static <T> Promise<T> create(Executor executor) {
        try {
            executor.execute();
        }
        catch (Throwable e) {
            return Promises.reject(e);
        }
        return Promises.of();
    }

    public static <T> Promise<T> of(T value) {
        DeferredImpl<T> deferred = new DeferredImpl<T>();
        deferred.resolve(value);
        return deferred.promise();
    }

    public static <T> Promise<T> of() {
        return Promises.of(null);
    }

    public static Promise<Void> voidPromise() {
        return Promises.of();
    }

    public static interface CombineCallback<F, S, R> {
        public R on(F var1, S var2);
    }
}

