/*
 * Decompiled with CFR 0.152.
 */
package com.rengwuxian.materialedittext;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.nineoldandroids.animation.ArgbEvaluator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.rengwuxian.materialedittext.Density;
import com.rengwuxian.materialedittext.R;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MaterialEditText
extends EditText {
    public static final int FLOATING_LABEL_NONE = 0;
    public static final int FLOATING_LABEL_NORMAL = 1;
    public static final int FLOATING_LABEL_HIGHLIGHT = 2;
    private int extraPaddingTop;
    private int extraPaddingBottom;
    private final int floatingLabelTextSize;
    private final int innerComponentsSpacing;
    private boolean floatingLabelEnabled;
    private boolean highlightFloatingLabel;
    private int baseColor;
    private int innerPaddingTop;
    private int innerPaddingBottom;
    private int primaryColor;
    private int errorColor;
    private int maxCharacters;
    private boolean singleLineEllipsis;
    private final int bottomEllipsisSize;
    private boolean extendBottom;
    private String helperText;
    private String tempErrorText;
    private float floatingLabelFraction;
    private boolean floatingLabelShown;
    private float focusFraction;
    private ArgbEvaluator focusEvaluator = new ArgbEvaluator();
    Paint paint = new Paint(1);
    ObjectAnimator labelAnimator;
    ObjectAnimator labelFocusAnimator;
    View.OnFocusChangeListener interFocusChangeListener;
    View.OnFocusChangeListener outerFocusChangeListener;

    public MaterialEditText(Context context) {
        this(context, null);
    }

    public MaterialEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialEditText(Context context, AttributeSet attrs, int style) {
        super(context, attrs, style);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setClickable(true);
        this.floatingLabelTextSize = this.getResources().getDimensionPixelSize(R.dimen.floating_label_text_size);
        this.innerComponentsSpacing = this.getResources().getDimensionPixelSize(R.dimen.inner_components_spacing);
        this.bottomEllipsisSize = this.getResources().getDimensionPixelSize(R.dimen.bottom_ellipsis_height);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaterialEditText);
        this.baseColor = typedArray.getColor(R.styleable.MaterialEditText_baseColor, -16777216);
        ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842910}, EMPTY_STATE_SET}, new int[]{this.baseColor & 0xFFFFFF | 0xDF000000, this.baseColor & 0xFFFFFF | 0x44000000});
        this.setTextColor(colorStateList);
        this.primaryColor = typedArray.getColor(R.styleable.MaterialEditText_primaryColor, this.baseColor);
        this.setFloatingLabelInternal(typedArray.getInt(R.styleable.MaterialEditText_floatingLabel, 0));
        this.errorColor = typedArray.getColor(R.styleable.MaterialEditText_errorColor, Color.parseColor((String)"#e7492E"));
        this.maxCharacters = typedArray.getInt(R.styleable.MaterialEditText_maxCharacters, 0);
        this.singleLineEllipsis = typedArray.getBoolean(R.styleable.MaterialEditText_singleLineEllipsis, false);
        this.helperText = typedArray.getString(R.styleable.MaterialEditText_helperText);
        this.extendBottom = typedArray.getBoolean(R.styleable.MaterialEditText_extendBottom, false) || this.helperText != null || this.maxCharacters > 0 || this.singleLineEllipsis;
        typedArray.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
        if (this.singleLineEllipsis) {
            TransformationMethod transformationMethod = this.getTransformationMethod();
            this.setSingleLine();
            this.setTransformationMethod(transformationMethod);
        }
        this.initPadding();
        this.initText();
        this.initFloatingLabel();
        this.initErrorTextListener();
    }

    private void initText() {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            Editable text = this.getText();
            this.setText(null);
            this.setHintTextColor(this.baseColor & 0xFFFFFF | 0x44000000);
            this.setText((CharSequence)text);
            this.floatingLabelFraction = 1.0f;
            this.floatingLabelShown = true;
        } else {
            this.setHintTextColor(this.baseColor & 0xFFFFFF | 0x44000000);
        }
    }

    private void initErrorTextListener() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                MaterialEditText.this.tempErrorText = null;
                MaterialEditText.this.invalidate();
            }
        });
    }

    private float getFloatingLabelFraction() {
        return this.floatingLabelFraction;
    }

    private void setFloatingLabelFraction(float floatingLabelFraction) {
        this.floatingLabelFraction = floatingLabelFraction;
        this.invalidate();
    }

    private float getFocusFraction() {
        return this.focusFraction;
    }

    private void setFocusFraction(float focusFraction) {
        this.focusFraction = focusFraction;
        this.invalidate();
    }

    private int getPixel(int dp) {
        return Density.dp2px(this.getContext(), dp);
    }

    private void initPadding() {
        this.extraPaddingTop = this.floatingLabelEnabled ? this.floatingLabelTextSize + this.innerComponentsSpacing : this.innerComponentsSpacing;
        this.extraPaddingBottom = this.extendBottom ? this.floatingLabelTextSize : 0;
        this.extraPaddingBottom += this.innerComponentsSpacing * 2;
        this.setPaddings(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
    }

    @Deprecated
    public final void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
    }

    public void setPaddings(int left, int top, int right, int bottom) {
        this.innerPaddingTop = top;
        this.innerPaddingBottom = bottom;
        super.setPadding(left, top + this.extraPaddingTop, right, bottom + this.extraPaddingBottom);
    }

    public int getInnerPaddingTop() {
        return this.innerPaddingTop;
    }

    public int getInnerPaddingBottom() {
        return this.innerPaddingBottom;
    }

    private void initFloatingLabel() {
        if (this.floatingLabelEnabled) {
            this.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void afterTextChanged(Editable s) {
                    if (s.length() == 0) {
                        if (MaterialEditText.this.floatingLabelShown) {
                            MaterialEditText.this.floatingLabelShown = false;
                            MaterialEditText.this.getLabelAnimator().reverse();
                        }
                    } else if (!MaterialEditText.this.floatingLabelShown) {
                        MaterialEditText.this.floatingLabelShown = true;
                        if (MaterialEditText.this.getLabelAnimator().isStarted()) {
                            MaterialEditText.this.getLabelAnimator().reverse();
                        } else {
                            MaterialEditText.this.getLabelAnimator().start();
                        }
                    }
                }
            });
            if (this.highlightFloatingLabel) {
                this.interFocusChangeListener = new View.OnFocusChangeListener(){

                    public void onFocusChange(View v, boolean hasFocus) {
                        if (hasFocus) {
                            if (MaterialEditText.this.getLabelFocusAnimator().isStarted()) {
                                MaterialEditText.this.getLabelFocusAnimator().reverse();
                            } else {
                                MaterialEditText.this.getLabelFocusAnimator().start();
                            }
                        } else {
                            MaterialEditText.this.getLabelFocusAnimator().reverse();
                        }
                        if (MaterialEditText.this.outerFocusChangeListener != null) {
                            MaterialEditText.this.outerFocusChangeListener.onFocusChange(v, hasFocus);
                        }
                    }
                };
                super.setOnFocusChangeListener(this.interFocusChangeListener);
            }
        }
    }

    public void setBaseColor(int color) {
        this.baseColor = color;
        this.postInvalidate();
    }

    public void setPrimaryColor(int color) {
        this.primaryColor = color;
        this.postInvalidate();
    }

    private void setFloatingLabelInternal(int mode) {
        switch (mode) {
            case 1: {
                this.floatingLabelEnabled = true;
                this.highlightFloatingLabel = false;
                break;
            }
            case 2: {
                this.floatingLabelEnabled = true;
                this.highlightFloatingLabel = true;
                break;
            }
            default: {
                this.floatingLabelEnabled = false;
                this.highlightFloatingLabel = false;
            }
        }
    }

    public void setFloatingLabel(int mode) {
        this.setFloatingLabelInternal(mode);
        this.postInvalidate();
    }

    public void setSingleLineEllipsis() {
        this.setSingleLineEllipsis(true);
    }

    public void setSingleLineEllipsis(boolean enabled) {
        this.singleLineEllipsis = enabled;
        if (enabled) {
            this.extendBottom();
        }
        this.postInvalidate();
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public void setMaxCharacters(int max) {
        this.maxCharacters = max;
        if (max > 0) {
            this.extendBottom();
        }
        this.postInvalidate();
    }

    public void setErrorColor(int color) {
        this.errorColor = color;
        this.postInvalidate();
    }

    public void setHelperText(CharSequence helperText) {
        this.helperText = helperText == null ? null : helperText.toString();
        this.extendBottom();
        this.postInvalidate();
    }

    public String getHelperText() {
        return this.helperText;
    }

    public void setError(CharSequence errorText) {
        this.extendBottom();
        this.tempErrorText = errorText == null ? null : errorText.toString();
        this.postInvalidate();
    }

    private void extendBottom() {
        if (!this.extendBottom) {
            this.extendBottom = true;
            this.initPadding();
        }
    }

    private boolean isInternalValid() {
        return this.tempErrorText == null && this.isMaxCharactersValid();
    }

    public boolean isValid(String regex) {
        if (regex == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher((CharSequence)this.getText());
        return matcher.matches();
    }

    public boolean validate(String regex, CharSequence errorText) {
        boolean isValid = this.isValid(regex);
        if (!isValid) {
            this.setError(errorText);
        }
        this.postInvalidate();
        return isValid;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener listener) {
        if (this.interFocusChangeListener == null) {
            super.setOnFocusChangeListener(listener);
        } else {
            this.outerFocusChangeListener = listener;
        }
    }

    private ObjectAnimator getLabelAnimator() {
        if (this.labelAnimator == null) {
            this.labelAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"floatingLabelFraction", (float[])new float[]{0.0f, 1.0f});
        }
        return this.labelAnimator;
    }

    private ObjectAnimator getLabelFocusAnimator() {
        if (this.labelFocusAnimator == null) {
            this.labelFocusAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"focusFraction", (float[])new float[]{0.0f, 1.0f});
        }
        return this.labelFocusAnimator;
    }

    protected void onDraw(@NonNull Canvas canvas) {
        this.paint.setTextSize((float)this.floatingLabelTextSize);
        float lineStartY = this.getScrollY() + this.getHeight() - this.getPaddingBottom() + this.innerComponentsSpacing;
        if (!this.isInternalValid()) {
            this.paint.setColor(this.errorColor);
            canvas.drawRect((float)this.getScrollX(), lineStartY, (float)(this.getWidth() + this.getScrollX()), lineStartY + (float)this.getPixel(2), this.paint);
        } else if (!this.isEnabled()) {
            this.paint.setColor(this.baseColor & 0xFFFFFF | 0x44000000);
            float interval = this.getPixel(1);
            for (float startX = 0.0f; startX < (float)this.getWidth(); startX += interval * 3.0f) {
                canvas.drawRect((float)this.getScrollX() + startX, lineStartY, (float)this.getScrollX() + startX + interval, lineStartY + (float)this.getPixel(1), this.paint);
            }
        } else if (this.hasFocus()) {
            this.paint.setColor(this.baseColor);
            canvas.drawRect((float)this.getScrollX(), lineStartY, (float)(this.getWidth() + this.getScrollX()), lineStartY + (float)this.getPixel(2), this.paint);
        } else {
            this.paint.setColor(this.baseColor);
            canvas.drawRect((float)this.getScrollX(), lineStartY, (float)(this.getWidth() + this.getScrollX()), lineStartY + (float)this.getPixel(1), this.paint);
        }
        Paint.FontMetrics fontMetrics = this.paint.getFontMetrics();
        float relativeHeight = -fontMetrics.ascent - fontMetrics.descent;
        if (this.maxCharacters > 0) {
            this.paint.setColor(this.isMaxCharactersValid() ? this.getCurrentHintTextColor() : this.errorColor);
            String text = this.getText().length() + " / " + this.maxCharacters;
            canvas.drawText(text, (float)(this.getWidth() + this.getScrollX()) - this.paint.measureText(text), lineStartY + (float)this.innerComponentsSpacing + relativeHeight, this.paint);
        }
        float bottomTextStartX = this.getScrollX() + (this.singleLineEllipsis ? this.bottomEllipsisSize * 5 + this.getPixel(4) : 0);
        if (this.tempErrorText != null) {
            this.paint.setColor(this.errorColor);
            canvas.drawText(this.tempErrorText, bottomTextStartX, lineStartY + (float)this.innerComponentsSpacing + relativeHeight, this.paint);
        } else if (!TextUtils.isEmpty((CharSequence)this.helperText)) {
            this.paint.setColor(this.getCurrentHintTextColor());
            canvas.drawText(this.helperText, bottomTextStartX, lineStartY + (float)this.innerComponentsSpacing + relativeHeight, this.paint);
        }
        if (this.floatingLabelEnabled && !TextUtils.isEmpty((CharSequence)this.getHint())) {
            this.paint.setColor(((Integer)this.focusEvaluator.evaluate(this.focusFraction, (Object)this.getCurrentHintTextColor(), (Object)this.primaryColor)).intValue());
            int start = this.innerPaddingTop + this.floatingLabelTextSize + this.innerComponentsSpacing;
            int distance = this.innerComponentsSpacing;
            int position = (int)((float)start - (float)distance * this.floatingLabelFraction);
            int alpha = (int)(this.floatingLabelFraction * 255.0f * (0.74f * this.focusFraction + 0.26f));
            this.paint.setAlpha(alpha);
            canvas.drawText(this.getHint().toString(), (float)(this.getPaddingLeft() + this.getScrollX()), (float)position, this.paint);
        }
        if (this.hasFocus() && this.singleLineEllipsis && this.getScrollX() != 0) {
            this.paint.setColor(this.primaryColor);
            float startY = lineStartY + (float)this.innerComponentsSpacing;
            canvas.drawCircle((float)(this.bottomEllipsisSize / 2 + this.getScrollX()), startY + (float)(this.bottomEllipsisSize / 2), (float)(this.bottomEllipsisSize / 2), this.paint);
            canvas.drawCircle((float)(this.bottomEllipsisSize * 5 / 2 + this.getScrollX()), startY + (float)(this.bottomEllipsisSize / 2), (float)(this.bottomEllipsisSize / 2), this.paint);
            canvas.drawCircle((float)(this.bottomEllipsisSize * 9 / 2 + this.getScrollX()), startY + (float)(this.bottomEllipsisSize / 2), (float)(this.bottomEllipsisSize / 2), this.paint);
        }
        super.onDraw(canvas);
    }

    public boolean isMaxCharactersValid() {
        return this.maxCharacters <= 0 || this.getText() == null || this.getText().length() <= this.maxCharacters;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.singleLineEllipsis && this.getScrollX() > 0 && event.getAction() == 0 && event.getX() < (float)this.getPixel(20) && event.getY() > (float)(this.getHeight() - this.extraPaddingBottom - this.innerPaddingBottom) && event.getY() < (float)(this.getHeight() - this.innerPaddingBottom)) {
            this.setSelection(0);
            return false;
        }
        return super.onTouchEvent(event);
    }
}

